proc(y) = ew2inn(t,p)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rICfil, calibrIC
; -----------------------------------------------------------------
;   Macro        ew2inn
; -----------------------------------------------------------------
;   Description  Auxiliary routine for rICfil:
;                     calculates E[ min(t^2,u^2) ] 
;                     for u square root of a Chi^2_p-variable, 
;                     (recursively in dimension p)
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rIC
; -----------------------------------------------------------------
;   Usage          y=ew2inn(t,p)
;   Input
;     Parameter   t
;     Definition     numeric; clipping height
;     Parameter   p
;     Definition     integer; dimension of X
; Output                                                           
;     Parameter   y
;     Definition     numeric; y=E[ min(t^2,u^2) ] 
; -----------------------------------------------------------------
; Notes
;    Not to be used outside of rICfil!
;
;      Is called by numint2 numint2m stointp stointpm.
;
;      Calles [within kalman.lib] betrnormF betrnormV.
; -----------------------------------------------------------------
;   Example   to be looked up in rICfil
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------
  
 
 
vu=betrnormV(t,p)
fu=betrnormF(t,p)
 
y= t^2.*(1-fu)+vu	
endp
