proc() = financetest()
; -----------------------------------------------------------------
; Library        finance
; -----------------------------------------------------------------
;  See_also     
; -----------------------------------------------------------------
;   Macro        financetest
; -----------------------------------------------------------------
;   Description   self test of extreme value module
; -----------------------------------------------------------------
;   Usage        financetest()
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------

; test if qf is inverse of df

  t=(1:999)/1000

  xtrcheck (t, -1.3, "ev", "evdf/evqf failed")
  xtrcheck (t, 0, "ev", "evdf/evqf failed")
  xtrcheck (t, 0.9, "ev", "evdf/evqf failed")

  xtrcheck (t, 0.1, "ev1", "ev1df/ev1qf failed")
  xtrcheck (t, 1, "ev1", "ev1df/ev1qf failed")
  xtrcheck (t, 1.3, "ev1", "ev1df/ev1qf failed")

  xtrcheck (t, -0.1, "ev2", "ev2df/ev2qf -0.1 failed")
  xtrcheck (t, -1, "ev2", "ev2df/ev2qf -1 failed")
  xtrcheck (t, -1.3, "ev2", "ev2df/ev2qf -1.3 failed")

  xtrcheck (t, 0, "ev0", "ev0df/ev0qf failed")

  xtrcheck (t, -1.3, "gp", "gpdf/gpqf failed")
  xtrcheck (t, 0, "gp", "gpdf/gpqf failed")
  xtrcheck (t, 0.9, "gp", "gpdf/gpqf failed")

  xtrcheck (t, 0.3, "gp1", "gp1df/gp1qf failed")
  xtrcheck (t, 1, "gp1", "gp1df/gp1qf failed")
  xtrcheck (t, 1.3, "gp1", "gp1df/gp1qf failed")

  xtrcheck (t, -0.1, "gp2", "gp2df/gp2qf -0.1 failed")
  xtrcheck (t, -1, "gp2", "gp2df/gp2qf -1 failed")
  xtrcheck (t, -1.3, "gp2", "gp2df/gp2qf -1.3 failed")

  xtrcheck (t, 0, "gp0", "gp0df/gp0qf failed")

; test densities by deriving df numerically

  xtrdencheck (-0.3, "ev")
  xtrdencheck (0, "ev")
  xtrdencheck (0.5, "ev")

  xtrdencheck (-0.3, "gp")
  xtrdencheck (0, "gp")
  xtrdencheck (0.5, "gp")

  xtrdencheck (0.3, "ev1")
  xtrdencheck (1, "ev1")
  xtrdencheck (1.5, "ev1")

  xtrdencheck (0.3, "gp1")
  xtrdencheck (1, "gp1")
  xtrdencheck (1.5, "gp1")

  xtrdencheck (-0.3, "ev2")
  xtrdencheck (-1, "ev2")
  xtrdencheck (-1.5, "ev2")

  xtrdencheck (-0.3, "gp2")
  xtrdencheck (-1, "gp2")
  xtrdencheck (-1.5, "gp2")

  xtrdencheck (0, "ev0")
  xtrdencheck (0, "gp0")

; test GP estimators 

  x = #(42.719, 105.86, 29.172, 22.654, 61.992, 35, 26.891, 25.59, 24.13)
  x = x | #(23.208, 37.772, 34.126, 27.99, 53.472, 36.269, 31.088, 25.907, 22)
  xtrcheck1 (mlegp (x, 18), 0.253832, 22, 11.9483, "mlegp failed")
;  xtrcheck1 (momentgp (x, 18), 0.293, 22, 12.08, "momentgp failed")
  xtrcheck1 (dpgp (x, 18), 0.902807, 22, 8.6187, "dpgp failed")
  xtrcheck1 (momentgp (x, 18), 0.293, 22, 12.06, "momentgp failed")

  m = hillgp1 (x, 18)
  xtrcheck2 (m.alpha, m.sigma, 2.21879, 22, "hillgp1 failed")
  m = mlegp0 (x, 18)
  xtrcheck2 (m.mu, m.sigma, 22, 15.8729, "mlegp0 failed")

; test diagram options

  xtrdiagcheck ("mlegp", "mlegpdiag", x, "mlegpdiag failed")
  xtrdiagcheck ("dpgp", "dpgpdiag", x, "dpgpdiag failed")
  xtrdiagcheck ("pickandsgp", "pickandsgpdiag", x, "pickandsgpdiag failed")
  xtrdiagcheck ("momentgp", "momentgpdiag", x, "momentgpdiag failed")

  xtrdiagcheck2 ("hillgp1", "hillgp1diag", x, "hillgpdiag failed")

; test EV estimators

  xtrcheck1 (lrseev (x), 0.507231, 27.151, 8.1062, "lrseev failed")
  xtrcheck1 (mleev (x), 0.718517, 26.8983, 5.8546, "mleev failed")
  m = mleev0 (x)
  xtrcheck2 (m.mu, m.sigma, 29.8036, 10.065, "mleev0 failed")

endp

proc () = xtrcheck (x, shape, name, s)
  y = cdfx (name, qfx (name, x, shape), shape)
  d = sum (abs (x - y))
  if (d > 1e-7)
    d
    error (d > 1e-7, s)
  endif
endp

proc () = xtrcheck1 (r, g, m, s, mes)
  d = abs (r.gamma - g) + abs (r.mu - m) + abs (r.sigma - s)
  if (d > 1e-2)
    d
    error (d > 1e-2, mes)
  endif
endp

proc () = xtrcheck2 (p1, p2, s1, s2, mes)
  d = abs (p1 - s1) + abs (p2 - s2)
  if (d > 1e-2)
    d
    error (d > 1e-2, mes)
  endif
endp

proc () = xtrdencheck (shape, name) 
  t = (-10:10) + 1e-5
  eps = 1e-6
  x1 = pdfx (name, t, shape)
  x2 = (cdfx (name, t + eps, shape) - cdfx (name, t, shape)) / eps
  d = sum (abs (x1 - x2))
  error (d > 1e-5, "Density Error in " + name)
endp

proc () = xtrdiagcheck (est, diag, x, mes)
  k = #(9,12,14)
  d = _diag (x, k)
  m1 = _est (x, 9)
  m2 = _est (x, 12)
  m3 = _est (x, 14)
  e = #(m1.gamma, m2.gamma, m3.gamma)
  f = sum (abs (d - e))
  error (f > 1e-10, "Error in " + mes)
endp

proc () = xtrdiagcheck2 (est, diag, x, mes)
  k = #(8,10,14)
  d = _diag (x, k)
  m1 = _est (x, 8)
  m2 = _est (x, 10)
  m3 = _est (x, 14)
  e = #(m1.alpha, m2.alpha, m3.alpha)
  f = sum (abs (d - e))
  error (f > 1e-10, "Error in " + mes)
endp
