proc(x)=genexpar(thrlag,gamma,phi0,phi1,noise)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  gentar, genbil, genarma, genarch
; ----------------------------------------------------------------------
;   Macro	  genexpar
; ----------------------------------------------------------------------
;   Description   generates an exponential AR process              
; ----------------------------------------------------------------------
;   Usage         x=genexpar(thrlag,gamma,phi0,phi1,noise)
;   Input 
;     Parameter   thrlag
;     Definition  integer: threshold lag
;     Parameter   gamma
;     Definition  scalar (gamma>0): coefficient in the exponential function
;     Parameter   phi0
;     Definition  vector (length p=AR order): AR coefficients for |X(t-thrlag)|=infinity
;     Parameter   phi1
;     Definition  vector (length p=AR order): AR coefficients for |X(t-thrlag)|=0
;     Parameter   noise
;     Definition  vector (length n=sample size needed): noise vector
;   Output
;     Parameter   x
;     Definition  generated EXPAR process
; ----------------------------------------------------------------------
;   Example       library("times")
;                 randomize(0)
;                 x=genexpar(1,0.1,0.3|0.6, 2.2|-0.8,normal(500))
;                 x[1:5]
; ----------------------------------------------------------------------
;   Result        Contents of _tmp 
;                 [1,]  -3.6098 
;                 [2,]  -4.6684 
;                 [3,]  -2.0478 
;                 [4,]  -2.9816 
;                 [5,]  -4.7075 
; ----------------------------------------------------------------------
;   Author        Rong Chen, Christian Hafner, 970723
; ----------------------------------------------------------------------
  nobs=rows(noise)
  p=rows(phi0)
  if(rows(phi1)<>p)
    "Warning: phi0 and phi1 have different length"
  endif
  n1=100
  pp=max(p|thrlag)
  y=matrix(max(n1|nobs),1)
  y[1:pp]=noise[1:pp]
  i=pp+1
  while(i <= n1)
     y[i]=sum(y[i-(1:p)].*(phi0.+((phi1-phi0).*exp(-gamma*y[i-thrlag]^2))))+noise[i]
     i=i+1
  endo
  y[1:pp]=y[n1-pp+(1:pp)]
  i=pp+1
  while(i <= nobs)
     y[i]=sum(y[i-(1:p)].*(phi0.+((phi1-phi0).*exp(-gamma*y[i-thrlag]^2))))+noise[i]
     i=i+1
  endo
  x=y[1:nobs]
endp
