proc(x)=gentar(nr,thrlag,thr,phi,noise)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  genexpar, genbil, genarma, genarch
; ----------------------------------------------------------------------
;   Macro	  gentar
; ----------------------------------------------------------------------
;   Description   generates a Threshold AR process              
; ----------------------------------------------------------------------
;   Usage         x=gentar(nr,thrlag,thr,phi,noise)
;   Input 
;     Parameter   nr 
;     Definition  integer: number of threshold regions
;     Parameter   thrlag
;     Definition  integer: threshold lag
;     Parameter   thr
;     Definition  vector (length nr-1): threshold values that 
;                 seperates the regions
;     Parameter   phi
;     Definition  vector (length nr*p): AR coefficients in each region.
;                 first p values are for the first region, etc.
;     Parameter   noise
;     Definition  vector (length n=sample size needed): noise vector
;   Output
;     Parameter   x
;     Definition  generated TAR process
; ----------------------------------------------------------------------
;   Example       library("times")
;                 randomize(0)
;		              x=gentar(2,1,0,0.5|-0.5,normal(300))
;                 x[1:5]
; ----------------------------------------------------------------------
;   Result        Contents of _tmp 
;                 [1,] -0.89391 
;                 [2,]  -1.4547 
;                 [3,]   1.2229 
;                 [4,]  -1.9166 
;                 [5,]  -2.3925 
; ----------------------------------------------------------------------
;   Author        Rong Chen, Christian Hafner, 970723
; ----------------------------------------------------------------------
  nobs=rows(noise)
  n1=100
  thr=thr|100000000
  nrp=rows(phi)
  p=floor(nrp/nr)
  if(((nrp/nr)-p)<>0) 
    "Error: length of phi is not multiple of nr"
  else
  pp=max(p|thrlag)
  y=matrix(max(n1|nobs),1)
  y[1:pp]=noise[1:pp]
  i=pp+1
  while(i <= n1)
     j=1
     while((y[i-thrlag]>thr[j]) && (j< (nr+1)))
       j=j+1
     endo
     jjj=(j-1)*p
     y[i]=sum(y[(i-1):(i-p)].*phi[(jjj+1):(jjj+p)])+noise[i]
     i=i+1
  endo
  y[1:pp]=y[n1-pp+(1:pp)]
  i=pp+1
  while(i <= nobs)
     j=1
     while((y[i-thrlag]>thr[j]) && (j< (nr+1)))
       j=j+1
     endo
     jjj=(j-1)*p
     y[i]=sum(y[(i-1):(i-p)].*phi[(jjj+1):(jjj+p)])+noise[i]
     i=i+1
  endo
  x=y[1:nobs]
  endif
endp
