proc(eta)=glminvlink(code,mu,opt)
; ----------------------------------------------------------------------------
; Library       glm
; ----------------------------------------------------------------------------
;  See_also     glmcore glmlink
; ----------------------------------------------------------------------------
;   Macro       glminvlink
; ----------------------------------------------------------------------------
;   Description  glminvlink computes the inverse link function.
; ----------------------------------------------------------------------------
;   Link  ../tutorials/glmstart.html Tutorial: GLM in XploRe 
; ----------------------------------------------------------------------------
;   Usage        eta = glminvlink(code,mu{,opt})
;   Input
;     Parameter   code 
;     Definition        text string, the short code for the model (e.g. 
;                       "bilo" for logit or "noid" for ordinary LS).
;     Parameter   mu  
;     Definition        n x d  matrix, the index values.
;     Parameter   opt
;     Definition        optional, a list with optional input. The macro
;                       "glmopt" can be used to set up this parameter.
;     Parameter   opt.pow
;     Definition        optional, power for power link. If not given, set 
;                       to 0 (logarithm).
;     Parameter   opt.nbk
;     Definition        scalar, extra parameter k for negative binomial
;                       distribution. If not given, set to 1 (geometric 
;                       distribution).
;   Output
;     Parameter   eta
;     Definition        n x d  matrix, the inverse link applied to mu.
; ----------------------------------------------------------------------------
;   Example   library("glm")
;             mu=0.5
;             mu=glminvlink("bilo",mu)
;             mu
; ----------------------------------------------------------------------------
;   Result    The logit is computed at mu=0.5:
;             Contents of mu
;             [1,]        0
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/18
; ----------------------------------------------------------------------------
;
  glmmodels=getglobal("glmmodels")
  binomial  = sum(code==(glmmodels.binomial)) >0
  power     = sum(code==(glmmodels.power)) >0
  identity  = sum(code==("noid")) >0
;
  switch
    case (binomial)
      switch
        case (code=="bilo")  
          eta=log(mu/(1-mu))
          break
        case (code=="bipro")  
          eta   = qfn(mu)
          break
        default ; code=="bicll"  
          eta   = log(-log(1-mu))
      endsw
      break
    case (identity)
      eta=mu
      break
    case (power)  
      p=0
      if (exist(opt)==9)
        if (comp(opt,"pow")>0)
          p=opt.pow
        endif
      endif
      if (p==0)
        eta=log(mu)
      else
        eta=mu^(p)
      endif
      break
    case (code=="polog")
      eta=log(mu)
      break
    case (code=="gacl")
      eta=1./mu
      break
    case (code=="igcl")
      eta=1./mu^2
      break
    case (code=="nbcl")
      k=1
      if (exist(opt)==9)
        if (comp(opt,"nbk")>0)
          k=opt.nbk
        endif
      endif
      eta=log(mu./(k+mu))
      break
    default 
      error(0==0, "glm: '"+code+"' is not (yet?) a valid model")
      break 
  endsw
endp

