proc(b,bv,df,m,mg,it,ret)=gplmcore(code,x,t,y,h,wx,wt,wc,b0,m0,off,ctrl,upb,tg,m0g)
; ----------------------------------------------------------------------------
; Library       gplm
; ----------------------------------------------------------------------------
;  See_also     sker dlcall gplmopt gplminit gplmest gplmstat
; ----------------------------------------------------------------------------
;   Macro       gplmcore
; ----------------------------------------------------------------------------
;   Description  gplmcore fits a  generalized partially linear model
;                E(y|x,t) = G(x*b + m(t)).
;                This is the core macro for GPLM estimation. It assumes
;                that all input variables are given in the right manner.
;                No preparation of data is performed. A more convenient
;                way to estimate a GPLM is to call the function gplmest.
; ----------------------------------------------------------------------------
;   Keywords    GPLM, Generalized Partial Linear Models
; ----------------------------------------------------------------------------
;   Reference   Speckman, JRSSB, 1988; Hastie/Tibshirani, 1989
; ----------------------------------------------------------------------------
;   Link   ../tutorials/gplmstart.html Tutorial: GPLM in XploRe 
; ----------------------------------------------------------------------------
;   Usage        {b,bv,df,m,mg,it} 
;                     = gplmcore(code,x,t,y,h,wx,wt,wc,b0,m0,ctrl{,upb{,tg,m0g}})
;   Input
;     Parameter   code  
;     Definition        text string, the short code for the model (e.g. 
;                       "bilo" for logit or "noid" for ordinary PLM).
;     Parameter   x  
;     Definition        n x p  matrix, the discrete predictor variables.
;     Parameter   t  
;     Definition        n x q  matrix, the continuous predictor variables.
;                       Needs to be SORTED by the first column. 
;     Parameter   y  
;     Definition        n x d  vector, the response variables.
;     Parameter   h  
;     Definition        q x 1  vector, the bandwith.
;     Parameter   wx
;     Definition        n x 1 vector or scalar, prior weights, e.g. the  
;                       binomial index vector.
;     Parameter   wt  
;     Definition        n x 1  vector or scalar, weights for t (trimming 
;                       factors). Is ignored, when scalar.
;     Parameter   wc 
;     Definition        n x 1  vector or scalar, weights for convergence 
;                       criterion, w.r.t. m(t) only. Is ignored, when scalar.
;     Parameter   b0  
;     Definition        p x 1 vector, the initial coefficients. 
;     Parameter   m0  
;     Definition        n x 1 vector or scalar, the initial values for the 
;                       nonparametric part. Is ignored and can be set to 
;                       scalar direct update for nonparametric function is
;                       possible (code="noid").
;     Parameter   off
;     Definition        n x 1 vector or scalar, offset. Is ignored when 0.
;     Parameter   ctrl  
;     Definition        7 x 1 vector or scalar, contains control parameters
;                         shf   (default=0), 
;                         miter (default=10), 
;                         cnv   (default=0.0001), 
;                         fscor (default=0), 
;                         pow   (default=0, power for power link),
;                         nbk   (default=1, parameter for negative binomial),
;                         meth  (default=0, parameter for backfitting/profile).
;                       Alternatively, one can give here shf only. Set to 0 
;                       to use the defaults.
;                       The parameters correspond to the optional parameters 
;                       which can be given in gplminit. 
;                       They are all ignored when not applicable.
;     Parameter   upb  
;     Definition        optional, scalar, 0 or 1 (default). If set to
;                       0, the parameter b is not updated in the
;                       iteration.
;     Parameter   tg  
;     Definition        optional, ng x 1 vector, a grid for continuous part. 
;                       Needs to be SORTED by the first column. Is ignored,
;                       if set to NaN. 
;     Parameter   m0g  
;     Definition        optional, ng x 1 vector or scalar, the initial values 
;                       for the nonparametric part on the grid. Needs to be 
;                       given if direct update for nonparametric function 
;                       is not possible. Is ignored otherwise. Is ignored,
;                       if tg set to NaN. 
;   Output
;     Parameter   b
;     Definition        p x 1  vector, estimated coefficients 
;     Parameter   bv
;     Definition        p x p  matrix, estimated covariance matrix for coeff.
;     Parameter   m
;     Definition        n x 1  vector, estimated nonparametric part.
;     Parameter   df
;     Definition        scalar, approximated degrees of freedom.
;     Parameter   mg
;     Definition        ng x 1  vector, estimated nonparametric part on grid.
;                       Only available if tg was given.
;     Parameter   it
;     Definition        integer, number of iterations needed.
;     Parameter   ret
;     Definition        scalar, return code: 
;                         0  o.k., 
;                         1  maximal number of iterations reached
;                            (if applicable),
;                        -1  missing values have been encountered.
; ----------------------------------------------------------------------------
;   Example   library("gplm")
;             ;==========================
;             ;  simulate data 
;             ;==========================
;             n=100
;             b=1|2
;             p=rows(b)
;             x=2.*uniform(n,p)-1
;             t=sort(2.*uniform(n)-1,1)
;             m=cos(pi.*t)
;             y=( 1./(1+exp(-x*b-m)).>uniform(n) )
;             ;==========================
;             ;  semiparametric fit 
;             ;==========================
;             h  = 0.6
;             b0 = 0|0
;             mu0= (y+0.5)/2
;             m0 = log(mu0/(1-mu0))
;             sf = gplmcore("bilo",x,t,y,h,1,1,1,b0,m0,0,1)
;             b~sf.b
;             ;==========================
;             ;  plot
;             ;==========================
;             library("plot")
;             true=setmask(sort(t~m),"line","thin")
;             estm=setmask(sort(t~sf.m),"line","blue")
;             plot(true,estm)
; ----------------------------------------------------------------------------
;   Result    A generalized partially linear logit fit for E[y|x,t] is 
;             computed. sf.b contains the coefficients for the linear  
;             part. sf.m contains the estimated nonparametric part 
;             evaluated at observations t. The example gives the 
;             true b together with the GPLM estimate sf.b. Also, the  
;             estimated function sf.m is displayed together with the 
;             true fit m. 
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/10
; ----------------------------------------------------------------------------
;
  n=rows(x)
  p=cols(x)
  q=cols(t)
;
  glmmodels=getglobal("glmmodels")
;
  binomial  = sum(code==(glmmodels.binomial)) >0
  gaussian  = sum(code==(glmmodels.gaussian)) >0
  poisson   = sum(code==(glmmodels.poisson)) >0
  gamma     = sum(code==(glmmodels.gamma))>0
  igaussian = sum(code==(glmmodels.igaussian))>0
  nbinomial = sum(code==(glmmodels.nbinomial))>0
;
  canonical = sum(code==(glmmodels.canonical)) >0
  power     = sum(code==(glmmodels.power)) >0
;
; set defaults
;
  if (rows(ctrl)==1)
    ctrl=ctrl|10|0.0001|0|0|1|0
  endif
  if (rows(wx)==1)
    wx=wx.*matrix(n)
  endif
;
  shf  =(ctrl[1]==1)
  miter=ctrl[2]
  cnv  =ctrl[3]
  fscor=ctrl[4]
  pow  =ctrl[5]*(power)
  nbk  =ctrl[6]*(nbinomial)
  meth =ctrl[7]
;
  if ((code=="nopow")&&(pow==1))
    code="noid"
    power=0
  endif
  if ((code=="noid")&&(meth==1))
    meth=0
  endif
;
  if (power*(pow!=0))
    error(mean(y[,1])<=0,"gplmcore: mean(y) should be positive for power link")
  endif 
;
  if (exist(upb)==0)
    upb=1
  endif
;
  havegrid=0
  if (exist(tg)==1)
    if (countNaN(tg)!=prod(dim(tg)))
      havegrid=1
      ng=rows(tg)
    endif
  endif
;
  m=matrix(n)
  if (sum(isNaN(m0))>0)
    m0=0.*m
  endif
;
  mg=NaN
  if (havegrid)
    mg=matrix(ng)
  endif
  xnew=matrix(n,p)
;
  it=1
  crit=0
;
  one=matrix(n)
  xb =x*b0+off
  b=b0
  dev0=Inf
;
  if (meth==1)
    if (getenv("os")=="unix")
      dllname="gplm.so"
    else
      dllname="gplm.dll"
    endif
    exec(" handle=dlopen(dllname) ")   ; {re}open dll
;
    etafunc="gplmeta"+code
    xtildefunc="gplmxtilde"+code
    if (fscor==1)
      etafunc=etafunc+"fs"
      xtildefunc=xtildefunc+"fs"
    endif
    if (getenv("os")!="unix")   ; Borland C++ DLL functions need leading _
      xtildefunc="_"+xtildefunc 
      etafunc="_"+etafunc
    endif
    t=t./h'
    if (havegrid)
      tg=tg./h'
    endif
  endif
;
  do
    if (shf)
      if (fscor==1)
        "gplmcore/code='"+code+"/fs': iteration no. "+string("%1.0f", it)
      else
        "gplmcore/code='"+code+"': iteration no. "+string("%1.0f", it)
      endif
    endif
    if (meth<1) ; backfitting or simple profile likelihood
      if (fscor*(1-canonical))
        {ll1,ll2}=glmlld(code+"fs",xb+m0,y[,1],list(pow,nbk))
      else
        {ll1,ll2}=glmlld(code,xb+m0,y[,1],list(pow,nbk))
      endif
;
      zm=m0-ll1./ll2
      z =xb+zm
;
      wnew=wx.*ll2
      tmp=sker(t,h',"qua",wnew.*(one~zm~z~x))
      denom=tmp[,1]
      m=tmp[,2]./denom
      xnew=x-tmp[,4:cols(tmp)]./denom
      znew=z-tmp[,3]./denom
      if (havegrid)
        tmp=sker(t,h',"qua",wnew.*(one~zm),tg)
        mg=tmp[,2]./tmp[,1]
      endif
;
      if (upb)
        if (meth==-1) ; backfitting
          wnew=(wt.*wx.*ll2.*x)'
        else
          wnew=(wt.*wx.*ll2.*xnew)'
        endif
        B = wnew*xnew
        bv=-inv(B)
        b=-bv*(wnew*znew)
      endif
    else ; exact profile likelihood for binomial models
      tmp=sum(code==("bilo"|"bipro"|"biprofs"|"noid"))
      error(tmp!=1,"gplmcore: meth=1 is not implemented for code='"+code+"'!")
      if (upb)
        xnew=matrix(n,p)
        denom=one
        exec( "notok=dlcall(xtildefunc,n|q|p,xb,t,y[,1],wx,m0,x,m,xnew,denom)" )
        if (havegrid)
          exec( "notok=dlcall(etafunc,n|q|ng,xb,t,y[,1],wx,tg,m0g,mg)" )
        endif
        if (fscor*(1-canonical))
          {ll1,ll2}=glmlld(code+"fs",xb+m,y[,1],pow)
        else
          {ll1,ll2}=glmlld(code,xb+m,y[,1],pow)
        endif
        wnew=(wt.*wx.*ll2.*xnew)'
        B = wnew*xnew
        bv=-inv(B)
        b=b0+bv*sum(wt.*wx.*ll1.*xnew)'
      else
        exec( "notok=dlcall(etafunc,n|q|n,xb,t,y[,1],wx,t,m0,m)" )
        if (havegrid==1)  ; only if grid exists
          exec( "notok=dlcall(etafunc,n|q|ng,xb,t,y[,1],wx,tg,m0g,mg)" )
        endif
      endif
    endif
;
    if ((countNaN(b)==0)&&(countNaN(m)==0))
      eta=xb+m
      mu = glmlink(code,eta,list(pow,nbk))
      dev= 2*sum(wx.*glmll(code,y,y,list(nbk))-wx.*glmll(code,mu,y,list(nbk)))
      chgd = abs((dev-dev0)/dev0)
      db=b-b0
      chgb=sqrt( sum(db.*db)./sum(b0.*b0) )
      dm=m-m0
      if (rows(wc)==n)
        dm=dm.*wc
        m0=m0.*wc
      else
        dm=dm.*wt
        m0=m0.*wt
      endif
      chgm=sqrt( sum(dm.*dm)./sum(m0.*m0) )
      if (shf)
        b
        tmp=    "relative change in b:        "+string("%10.8f", chgb)
        tmp=tmp|"relative change in m:        "+string("%10.8f", chgm)
        tmp=tmp|"relative change in deviance: "+string("%10.8f", chgd)
        tmp
      endif
;
      crit=(((chgb<cnv)&&(chgm<cnv))||(chgd<cnv))
      it=it+1
      b0=b
      m0=m
      dev0=dev
      xb=x*b0+off
      if (havegrid==1)
        m0g=mg
      endif
      ret=(crit==0)&&(it>miter)
    else
      crit=1
      ret=-1
    endif
  until (crit+(it>miter))
  it=it-1
  if (shf&&(ret==-1))
    "gplmcore: missing values have been encountered!"
  endif
;
  df=0
  if (upb)
    if (meth<1)
      tmp=sker(t,h',"qua",ll2.*xnew)
      xnew=xnew-tmp./denom
      denom=denom.*n.*prod(h)
    else
      x=xnew
      exec( "notok=dlcall(xtildefunc,n|q|p,xb,t,y[,1],wx,m0,x,m,xnew,denom)" )
    endif
    tmp=wnew*xnew
    df=n+sum(xdiag(bv*tmp))-0.9375.*sum((wx.*ll2)./denom)
  endif
endp 




