proc()=graphictest()
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     graphicmain
; -----------------------------------------------------------------------
; Macro        graphictest
; -----------------------------------------------------------------------
; Description  Tests the macros of the graphic library.
; -----------------------------------------------------------------------
; Usage        graphictest()
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970424, Stephan R. W. Lauer, 990224
; -----------------------------------------------------------------------
      grc = getglobal ("grc")
; grandrews
      x  = read("bank2") 
      bp = grandrews (x, 50) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, bp) 
; grbar
      t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25) 
      bp = grbar (t) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, bp) 
; grbox
      t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25) 
      bp = grbox (t) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, bp) 
; grcircle
      x  = normal(100, 2)
      gc = grcircle (3.0)
      d  = createdisplay (1,1)
      show (d, 1, 1, x, gc)
; grcontour2
      x  = grid (#(-3,-3), #(0.25,0.25), #(25,25)) 
      f  = exp(-0.5.*(x[,1]^2+x[,2]^2))./(2.*pi) 
      c  = (1:9).*max(f)./10 
      gs = grcontour2 (x~f, c) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, gs) 
; grcontour3
      x  = grid (-#(3,3,3), #(0.5,0.5,0.5), #(13,13,13)) 
      f  = exp(-0.5.*sum(x^2,2))./(2.*pi)^1.5 
      c  = #(0.25, 0.5, 0.75).*max(f) 
      gs = grcontour3 (x~f, c) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, gs) 
; grdot
      t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25) 
      bp = grdot (t) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, bp) 
; grdotd
      t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25) 
      bp = grdotd (t) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, bp) 
; grdotdl
      t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25) 
      bp = grdotdl (t) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, bp) 
; grhist
      t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25) 
      bp = grhist (t) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, bp) 
; grlinreg
      x  = normal(100) 
      y  = 3*x+normal(100) 
      l  = grlinreg(x~y) 
      d  = createdisplay(1,1) 
      show(d,1,1,x~y,l) 
; grlinreg2
      x  = normal(100,2) 
      y  = 3*x[,1]+5*x[,2]+normal(100)
      l  = grlinreg2(x~y) 
      d  = createdisplay(1,1) 
      show(d,1,1,x~y,l) 
; grmove
      t   = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25) 
      bp1 = grdot (t) 
      bp2 = grmove (bp1, #(0, 2)) 
      d   = createdisplay (1,1) 
      show (d, 1, 1, bp1, bp2)
; grpcp
      x  = read("bank2") 
      bp = grpcp (x) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, bp) 
; grqq
      t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
      bp = grqq (t, t)
      d  = createdisplay (1,1)
      show (d, 1, 1, bp)
; grqqn
      t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
      bp = grqqn (t)
      d  = createdisplay (1,1)
      show (d, 1, 1, bp)
; grqqu
      t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
      bp = grqqu (t)
      d  = createdisplay (1,1)
      show (d, 1, 1, bp)
; grrot
      t   = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25) 
      bp1 = grdot (t) 
      bp2 = grrot (bp1, 1) 
      d   = createdisplay (1,1) 
      show (d, 1, 1, bp1, bp2) 
; grsurface
      x  = grid (#(-3,-3), #(0.1,0.1), #(61,61)) 
      f  = exp(-0.5.*(x[,1]^2+x[,2]^2))./(2.*pi) 
      gs = grsurface (x~f) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, gs) 
; grxline
      x  = normal(100, 2) 
      lx = grxline (0, x[,2])  
      ly = gryline (0, x[,1]) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, x, lx, ly) 
; gryline
      x  = normal(100, 2) 
      lx = grxline (0, x[,2])  
      ly = gryline (0, x[,1]) 
      d  = createdisplay (1,1) 
      show (d, 1, 1, x, lx, ly) 
; hls2rgb
      h = grid (0,1,360) 
      l = 0.5.*matrix(rows(h)) 
      s = matrix(rows(h)) 
      rgb = hls2rgb(h~l~s) 
; rgb2hls
      rgb = (0:255).*matrix(256,3) 
      hls = rgb2hls (rgb) 

; dispbox
              library("stats")
              x = normal(4000)
              m = matrix(1000)
              factor = m | 2*m | 3*m | 4*m
              bp1 = dispbox(x)
              bp2 = dispbox(x, factor)
              dd = createdisplay(1, 2)
              show(dd, 1, 1, bp1)
              show(dd, 1, 2, bp2)

; dispdot
              bp1 = dispdot(x, grcolorscheme("greyscale"))
              bp2 = dispdot(x, grcolorscheme("topographic"), factor)
              dd = createdisplay(1, 2)
              show(dd, 1, 1, bp1)
              show(dd, 1, 2, bp2)

; colorcube
              points = colorcube()
              dd = createdisplay(1, 1)
              show(dd, 1, 1, points)

endp
