proc(gc)=grcircle(radius, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grxline gryline
; -----------------------------------------------------------------------
; Macro        grcircle
; -----------------------------------------------------------------------
; Description  Generates a circle or ellipse as a graphical object. 
;              The circle is centered at (0,0) and has the given radius.
; -----------------------------------------------------------------------
; Usage        gc = grcircle (radius {, col})
; Input
;   Parameter  radius
;   Definition scalar 
;   Parameter  col
;   Definition color
; Output
;   Parameter  gc
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              x  = normal(100, 2)
;              gc = grcircle (3.0)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, x, gc)
; -----------------------------------------------------------------------
; Result       shows a bivariate normal disributed dataset and
;              a circle with radius 3.
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970119
; -----------------------------------------------------------------------
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black
  endif
  n  = 72
  t  = grid(0, 2*pi./(n-1), n) 
  gc = (cos(t)~sin(t)).*trans(radius)
  setmaskp (gc, 0, 0, 0)
  setmaskl (gc, (1:rows(gc))', col, 1, 2)
endp