proc(dp)=grdotd(x, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grbar grbox grhist grdot grdotdl grash
; -----------------------------------------------------------------------
; Macro        grdotd
; -----------------------------------------------------------------------
; Description  Generates a dotplot as a density plot.
; -----------------------------------------------------------------------
; Usage        bp = grdotd (x {, col})
; Input
;   Parameter  x 
;   Definition n x 1      vector
;   Parameter  col
;   Definition color
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              bp = grdotd (t)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a dotplot as a density plot
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, dotplot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
  error(cols(x).<>1, "grdot : cols(x)<>1")
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black
  endif  
  d=(max(x)-min(x))./100
  n=rows(x)
  {xb,yb}=bindata(x,d,0)             ; bin data
  sigma=sqrt(cov(x))
  h=2.7772*sigma*n^(-0.2)            ; determine h by rule of thumb
;  wy=symweigh(0,d/h,h/d,"qua")       ; create weights
  g=grid(0,d/h,h/d) 
  m=2^sum((g.<>0),2) 
  w=0.9375.*(1-g^2)^2 
  s=sum((m.*w),1)
  wy=w./s
; end of symweigh
  wx=aseq(0,rows(wy),1)
  {xc,yc,or}=conv(xb,yb,wx,wy)       ; calc density func
  yc = yc/(n*d)
  xc = xc-min(xb)+1
  fh = sort(xc~yc)
  xb = xb-min(xb)+1
  fh = index(fh[,2], xb)
  dp = x~(fh.*uniform(rows(x)))
  setmaskp (dp, col, 3, 4) 
endp