proc(grout)=grmove(grin,  shf)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grrot
; -----------------------------------------------------------------------
; Macro        grmove
; -----------------------------------------------------------------------
; Description  Moves a graphical object.
; -----------------------------------------------------------------------
; Usage        grout = grmove (grin, shf)
; Input
;   Parameter  grin
;   Definition composed graphical object
;   Parameter  shf
;   Definition 1 x 2 vector
; Output
;   Parameter  grout
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Notes        Technically grmove does a vector addition of grin with shf.
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t   = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              bp1 = grdot (t)
;              bp2 = grmove (bp1, #(0, 2))
;              d   = createdisplay (1,1)
;              show (d, 1, 1, bp1, bp2)
; -----------------------------------------------------------------------
; Result       shows the same dotplot twice, one shifted upward by 2
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
  grout = grin
  grout[,1] = grout[,1] + shf[1]
  grout[,2] = grout[,2] + shf[2]
endp