proc(gcol, gind)=groupcol(col, ncol)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     transform
; -----------------------------------------------------------------------
; Macro        groupcol
; -----------------------------------------------------------------------
; Description  Decomposes a (color) vector into single groups.
; -----------------------------------------------------------------------
; Usage        {g, gind} = groupcol (col, ncol)
; Input
;   Parameter  col
;   Definition scalar or color vector
;   Parameter  ncol
;   Definition scalar               expected length of colorvector
; Output
;   Parameter  gcol
;   Definition m x 1                different colors
;   Parameter  gind
;   Definition n x 1                index of groups
; -----------------------------------------------------------------------
; Example      ; loads the library graphic
;              library ("graphic")
;              ; generate a color vector, e.g. for swiss banknote
;              col = matrix(100)|(4*matrix(100))
;              ; computes the different colors
;              {gcol, gind} = groupcol (col, 200)
;              ; show the different colors
;              gcol
;              ; show the index vector (100 ones and 100 twos)
;              gind
; -----------------------------------------------------------------------
; Result       decompose a color vector and show the results
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970201
; -----------------------------------------------------------------------
  if (rows(col).=1)
    gcol = col
    gind = matrix(ncol)
  else
    error (rows(col).<>ncol, "groupcol : rows(col)<>ncol")
    if (cols(col).=3)
      dcol = col[,1]*65536+col[,2]*256+col[,3]
    else
      dcol = col[,1]
    endif
    dcol = sort(dcol~(1:ncol))
    ocol = dcol[,2]
    dcol = (1|(dcol[2:ncol,1]-dcol[1:ncol-1,1])).>0
    gcol = index (col, paf (ocol, dcol))
    dcol = sort(ocol~cumsum(dcol))
    gind = dcol[,2]
  endif
endp