proc(dp)=grpp(y, x, col)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     grppn grqqn grqqu
; -----------------------------------------------------------------------
; Macro        grpp
; -----------------------------------------------------------------------
; Description  generates a probability-probability-plot to compare two variables
; -----------------------------------------------------------------------
; Usage        bp = grpp (y, x {, col})
; Input
;   Parameter  y
;   Definition n x 1      vector
;   Parameter  x 
;   Definition n x 1      vector
;   Parameter  col
;   Definition color
; Output
;   Parameter  dp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      ; loads the library graphic
;              library ("graphic")
;              ; generate a dataset with 160 observations
;              t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              ; generate a pp-plot to compare t with t
;              bp = grqq (t, t)
;              ; create a dispplay for plotting
;              d  = createdisplay (1,1)
;              ; plot the pp-plot
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a pp-plot
; -----------------------------------------------------------------------
; Link         grstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
   error(cols(x).<>1, "grpp: cols(x)<>1")
   error(cols(y).<>1, "grpp : cols(y)<>1")
   error(rows(x).<>rows(y), "grqq : rows(x)<>rows(y)")
   if (exist("col").<>1)
     grc = getglobal ("grc")  
     col = grc.col.black
   endif
   n  = rows(x)
   sx = sort(x)
   sy = sort(y)
   l  = min(sx|sy)|max(sx|sy)
   dp = (sx~sy)|(l~l) 
   if (rows(col).=1)
     col = (col*matrix(n, cols(col)))|(0*matrix(2,cols(col)))
   else
     col = col|(0*matrix(2,cols(col)))
   endif
   pt = 3.*matrix(n)|0|0
   setmaskp (dp, col, pt, 3)
   setmaskl (dp, (n+1)~(n+2), 0, 1, 2)
endp