proc(dp)=grqq(y, x, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grqqn grqqu
; -----------------------------------------------------------------------
; Macro        grqq
; -----------------------------------------------------------------------
; Description  Generates a quantile-quantile-plot to compare two variables.
; -----------------------------------------------------------------------
; Usage        bp = grqq (y, x {, col})
; Input
;   Parameter  y
;   Definition n x 1      vector
;   Parameter  x 
;   Definition n x 1      vector
;   Parameter  col
;   Definition color
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      ; loads the library graphic
;              library ("graphic")
;              ; generate a dataset with 160 observations
;              t1  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              t2  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              ; generate a qq-plot to compare t1 with t2
;              bp = grqq (t1, t2)
;              ; create a dispplay for plotting
;              d  = createdisplay (1,1)
;              ; plot the qq-plot
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a qq-plot
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, quantile quantile plot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
   error(cols(x).<>1, "grqq : cols(x)<>1")
   error(cols(y).<>1, "grqq : cols(y)<>1")
   error(rows(x).<>rows(y), "grqq : rows(x)<>rows(y)")
   if (exist("col").<>1)
     grc = getglobal ("grc")  
     col = grc.col.black
   endif
   n  = rows(x)
   sx = sort(x)
   sy = sort(y)
   l  = min(min(sx)|min(sy))|max(max(sx)|max(sy))
   dp = (sx~sy)|(l~l) 
   if (rows(col).=1)
     col = (col*matrix(n, cols(col)))|(0*matrix(2,cols(col)))
   else
     col = col|(0*matrix(2,cols(col)))
   endif
   pt = 3.*matrix(n)|0|0
   setmaskp (dp, col, pt, 3)
   setmaskl (dp, (n+1)~(n+2), 0, 1, 2)
endp