proc(dp)=grqqn(x, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grqq grqqu
; -----------------------------------------------------------------------
; Macro        grqqn
; -----------------------------------------------------------------------
; Description  Generates a quantile-quantile-plot to compare a variable
;              with a normal distribution.
; -----------------------------------------------------------------------
; Usage        bp = grqqn (x{, col})
; Input
;   Parameter  x 
;   Definition n x 1      vector
;   Parameter  col
;   Definition color
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      ; loads the library graphic
;              library ("graphic")
;              ; generate a dataset with 160 observations
;              t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              ; generate a qq-plot to compare t with a normal distribution
;              bp = grqqn (t)
;              ; create a dispplay for plotting
;              d  = createdisplay (1,1)
;              ; plot the qq-plot
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a qq-plot
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, quantile quantile plot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
   error(cols(x).<>1, "grqqn : cols(x)<>1")
   if (exist("col").<>1)
     grc = getglobal ("grc")  
     col = grc.col.black
   endif
   n  = rows(x)
   q  = ((1:n)-0.5)./n
   y  = mean(x) + sqrt(var(x)) .* qfn(q)
   dp = grqq (x, y, col)
endp