proc(r,c,l,d,titl)=gruppenvariable(data,f,selvar,dcoltype)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     andrewscurv doista parallel showd  
; -----------------------------------------------------------------------
; Macro        gruppenvariable
; -----------------------------------------------------------------------
; Description  creates according the selected variables and group variables
;              the appropriate parameters d, c, r and title to build the 
;              displays in showd
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Marlene Mueller 970702  Kerstin Zanter 980616
;------------------------------------------------------------------------
    rn=rows(data.x)
    if(sum(selvar))
      datah=paf(data.x',selvar)' 
    endif
    ;datah=paf(data.x',1-data.coltype)'
    datah=paf(datah, data.rowcase&&data.randcase&&data.rowmissing)
    ;all variables selected
    sel1=choosegroup(data,selvar,dcoltype)
    if (sum(sel1)) ;group variable selected?
      sel1 = paf((1:rows(sel1)), sel1)
      ;select gruop variable
      r = 0
      c = 0
      d = 0
      l = list(0)
      titl = " "
      ;empty title (ignored)
      i = 0
      while (i<rows(sel1))
      ;loop over group variables
        i   = i+1
        sel = sel1[i]
        ;select first, second,....group variable
        colh=data.x[,sel] 
        ;Auspraegungen der Gruppenvariable als Farben
        {g,gind}=groupcol(colh, rn)
        if(max(gind).<7)
        ;group variable only if <7 different values
            r = r|i
            c = c|1
            d = d|1         
            append(l, _f(datah, gind+1))
            titl = titl|("Group="+data.colname[sel])
        else
          obj="not enough colors"
          ;no computation
            r = r|i
            c = c|1
            d = d|1         
          append(l, obj)
          titl=titl|"Fehler"
        endif
      endo
    else
      ;show black curves without group variable
      r = 1
      c = 1
      d = 1
      l = _f(datah, 1)
      titl="no group"
    endif
endp
