proc (haz) = hazard(y, bandwidth)
; ----------------------------------------------------------------------
; Library 	  stats
; ----------------------------------------------------------------------
;   See_also	  kaplanmeier
;----------------------------------------------------------------------
;   Macro	  hazard
; ----------------------------------------------------------------------
;   Description   Nonparametric estimator of the hazard rate. The bandwidth
;                 parameter can be optionally chosen.
; ----------------------------------------------------------------------
;   Notes         hazard generates the graphical display    
; ----------------------------------------------------------------------
;   Usage         h = hazard (y {,bandwidth})
;   Input 
;     Parameter   y 
;     Definition  n x 2 matrix
;     Parameter   bandwidth
;     Definition  scalar
;   Output
;     Parameter   h
;     Definition  vector
; ----------------------------------------------------------------------
;   Example     ;Nonparametric estimator of the hazard rate for the leukaemia 
;               ; data, by using the default grid.
;               ; loads the library stats 
;               library("stats")
;               x = read("leukaemia.dat")
;               h = hazard(x)
;               h
; ----------------------------------------------------------------------
;   Result
;               Contents of h (first seven points)
;               [  1,]     5.95  0.16213 
;               [  2,]     6.12    0.165 
;               [  3,]     6.29  0.16729 
;               [  4,]     6.46  0.16895 
;               [  5,]     6.63  0.16995 
;               [  6,]      6.8  0.17026 
;               [  7,]     6.97  0.16986 
;-----------------------------------------------------------------------
;   Reference
;      Wand, M.P. and M.C. Jones (1995): Kernel Smoothing.  
;      Chapman & Hall
; ----------------------------------------------------------------------
;   Keywords
;      Hazard functions
; ----------------------------------------------------------------------
;   Author        Gilles Teyssiere, 980520
; ----------------------------------------------------------------------
  ;;
  y = sort(y,2) 
  TS = rows(y)  
  rd = paf(y,y[,1] == 1)
  ;;
  n = rows(rd)
  x = matrix(n,2)
  i = 1
  while (i <= n)
    t = rd[i,2]
    CDFM = (rows(paf(y,y[,2] <= t))-1)/TS
    x[i,1] = t
    x[i,2] = 1/(1-CDFM)
    i = i+1
  endo
  d = (max(x[,1])-min(x[,1]))/100   
  if (exist(bandwidth) == 1)
    h = bandwidth
  else
    sigma=sqrt(cov(x[,1]))
    h=1.06*sigma*n^(-0.2) ; this bandwidth may be changed
  endif
  {xb,yb}=bindata(x[,1],d,0,x[,2]) ; bin data in x and sum of y's   
  wy=symweigh(0,d/h,h/d,"qua")     ; create weights for quartic kernel
  wx=aseq(0,rows(wy),1)
  {xc,yc,or}=conv(xb,yb,wx,wy)       
  haz=(d.*xc)~(yc[,2]) 
  ; Graphical display
  hazard = createdisplay(1,1)
  w = setmask(haz,"line","solid","red")
  show(hazard,1,1,w)
  setgopt(hazard,1,1,"xlabel","time","ylabel","Hazard rate")
endp  

 

