proc(b,s,g)=heckman(x,y,z,q)
; -----------------------------------------------------------------
; Library        metrics
; -----------------------------------------------------------------
;  See_also      tobit powell select sssm andrews
; -----------------------------------------------------------------
;   Macro        heckman
; -----------------------------------------------------------------
;   Description  2-step estimation of a regression equation in the 
;		 presence of self-selection. Selection rule is of the 
;		 probit type (hence, this is a Type 2 Tobit Model in 
;		 chapter 10 of Amemiya's Advanced Econometrics).    
; -----------------------------------------------------------------
;   Usage        heckit = heckman(x,y,z,q)    
;   Input
;     Parameter   x  
;     Definition      n x d matrix , the observed explanatory variables 
;		      of the regression equation	    
;     Parameter   y 
;     Definition      n x 1 matrix , the observed response variable of the
;		      regression equation       
;     Parameter   z  
;     Definition      n x p matrix , the observed explanatory variables 
;		      of the selection equation	    
;     Parameter   q 
;     Definition      n x 1 matrix , the observed response variable of the
;		      regression equation;   
;   Output                                                                   
;     Parameter   heckit.b 
;     Definition       d x 1 vector, contains the estimated coefficients of the components of x 
;		       result of the second step					
;     Parameter   heckit.s 
;     Definition       scalar, contains the estimated covariance of the error terms
;		       in the selection equation and regression equation	
;		       result of the second step					
;     Parameter   heckit.g 
;     Definition       p x 1 vector, contains the estimated coefficients of the components of z, 
;		       result of the first step					
;     Reference	G.S. Maddala (1983): Limited-Dependent and Qualitative Variables in
;		Econometrics, Chapter 8	
; -----------------------------------------------------------------
;   Example   library("metrics")
;	n	=	500
;	s1	=	1
;	s2	=	1
;	s12	=	0.7
;	ss	=	#(s1,s12)~#(s12,s2)
;	ev	=	eigsm(ss)
;	va	=	ev.values
;	ve	=	ev.vectors
;	ll	=	diag(va)
;	ll	=	sqrt(ll)
;	sh	=	ve*ll*ve'
;	u	=	normal(n,2)*sh'
;	z	=	2*normal(n,2)
;	g	=	#(1,2)
;	q	=	(z*g+u[,1].>=0)
;	x	=	matrix(n)~aseq(1, n ,0.25)
;	b	=	#(-9, 1)
;	y	=	x*b+u[,2]
;	y	=	y.*(q.>0)
;       heckit 	= 	heckman(x,y,z,q)
;	heckit.b
;	heckit.s
;	heckit.g
; -----------------------------------------------------------------
;   Result    2-step estimates of b, s and g
; -----------------------------------------------------------------
;   Author    akw   06/05/96  
; -----------------------------------------------------------------
	probit = glmest("bipro",z, q) 
	g  = probit.b
	id = z*(probit.b)
	ld = pdfn(id)./(cdfn(id)+1e-10) 
	x  = x~ld
	zz  = y~x
	zz  = paf(zz, q)
	y  = zz[,1]
	x  = zz[,2:cols(zz)]
	bs = gls(x,y)
	b  = bs[1:(cols(x)-1),]
	s  = bs[cols(x),]
endp
  
