proc (rgb) = hls2rgb (hls)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     rgb2hls
; -----------------------------------------------------------------------
; Macro        hls2rgb
; -----------------------------------------------------------------------
; Description  Generates RGB colors from the HLS color model.
; -----------------------------------------------------------------------
; Usage        rgb = hls2rgb (hls)
; Input
;   Parameter  hls
;   Definition n x 3      array
; Output
;   Parameter  rgb
;   Definition n x 3      array
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              h = grid (0,1,360)
;              l = 0.5.*matrix(rows(h))
;              s = matrix(rows(h))
;              rgb = hls2rgb(h~l~s)
;              rgb
; -----------------------------------------------------------------------
; Result       computes the RGB colors from red-green-blue-red
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
  v = dim(hls)
  error (v[2]<>3, "hls2rgb : 3 columns expected")
  m2 = (hls[,2].<=0.5).*(hls[,2].*(1+hls[,3]))
  m2 = m2 + (hls[,2].>0.5).*(hls[,2]+hls[,3]-hls[,2].*hls[,3]) 
  m1 = 2.*hls[,2]-m2
  h  = (hls[,1]+120)/360
  h  = 360.*(h-floor(h))
  r  = (h.<60) .* (h./60)
  r  = r + ((h.>=60) && (h.<180))
  r  = r + ((h.>=180) && (h.<240)) .* (240-h)./60
  r  = m1 + r .* (m2-m1)
  h  = hls[,1]/360
  h  = 360.*(h-floor(h))
  g  = (h.<60) .* (h./60)
  g  = g + ((h.>=60) && (h.<180))
  g  = g + ((h.>=180) && (h.<240)) .* (240-h)./60
  g  = m1 + g .* (m2-m1)
  h  = (hls[,1]+240)/360
  h  = 360.*(h-floor(h))
  b  = (h.<60) .* (h./60)
  b  = b + ((h.>=60) && (h.<180))
  b  = b + ((h.>=180) && (h.<240)) .* (240-h)./60
  b  = m1 + b .* (m2-m1)
  rgb = 255.9999.*(r~g~b)
endp