proc(yy)=ivforec(h,yh,covdyd,z)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     forec2, forecast 
; -----------------------------------------------------------------
;   Macro        ivforec
; -----------------------------------------------------------------
;   Description  Computes forecast intervals for VAR Models
; -----------------------------------------------------------------
;   Usage        yy=ivforec(h,yh,covdyd,z)  
;   Input
;     Parameter   h
;     Definition      scalar, forecast horizon
;     Parameter   yh
;     Definition      matrix, forecasts of variables
;     Parameter   covdyd
;     Definition      matrix, forecast mse 
;     Parameter   z 
;     Definition    scalar, 1.96 for alpha=0.95
;   Output
;     Parameter   yy
;     Definition    matrix, forecast intervals
; -----------------------------------------------------------------
;   Author    Christian Hafner 981230
; -----------------------------------------------------------------
di=rows(yh)/h
i=1
iv=0
while (i<=h)
   s=xdiag(covdyd[di*(i-1)+1:di*i,])
   iv=iv|s
   i=i+1
endo
iv=iv[2:rows(iv),]^.5*z
yy=yh-iv~yh+iv
endp
