proc()=kalmantest()
; -----------------------------------------------------------------------
; Library      kalman
; -----------------------------------------------------------------------
; See_also     kalmanmain
; -----------------------------------------------------------------------
; Macro        kalmantest
; -----------------------------------------------------------------------
; Description  Tests the quantlets of the kalman library.
; -----------------------------------------------------------------------
; Usage        kalmantest()         
; -----------------------------------------------------------------------
; Author       A. Ossetrova, 000407
; -----------------------------------------------------------------------

; epscontnorm:                  
                   randomize(0)
                   T = 100
                   eps = 0.1
                   mid=#(0,0)
                   Cid = #(2,1)~#(1,1)
                   mcont=#(3,3)
                   Ccont = #(3,0)~#(0,0.2)
                   erg=epscontnorm(T,eps,mid,Cid,mcont,Ccont,0)
                   color=2*erg.Ind+2 ; red (4)  if clipped green (2) else
                   data=erg.X
                   setmaskp(data,color, 3, 8) ; rest :default
                   disp = createdisplay(1,1)
                   show(disp,1,1,data)
                                          ; epscontnorm (eps-contamination Model)
                                          ;Generates 100 observations of 
                                          ;(1-eps) N(0,Cid)+eps N(mcont,Ccont)
                                          ;and plots the contaminated data

; kemitor2

             randomize(0)
             T = 100
             mu=0
             H = 1
             F = 1
             mid=0
             Cid=1
             mcont=10
             Ccont=0.1
             eps=0.1
             ErrX = normal(T)
             ErrY = epscontnorm(T,eps,mid,Cid,mcont,Ccont,0)
             sim = kemitor2(T,mu,H,F,ErrY,ErrX)
             state = (1:100)~(sim.X)
             obs= (1:100)~(sim.Y)
             ind = (ErrY.Ind)
             ind=ind/ind*0 ;           sets all "0" to missing and all "1" to 0 
             ind = (1:100)~ind
             setmaskp(ind,4, 3, 8)  ;       on all contam. instances a red flag is plotted
             state=setmask(state,"line","blue","thin")          
             obs=setmask(obs,"line","green","thin")          
             disp = createdisplay(1,1)
             show(disp,1,1,state,obs,ind)
             setgopt(disp,1,1, "title", "State Space Model (1 - dim steady state) under AO")

                                                ; Generates a simulation of length 100 of 
                                                ; a steady state model (i.e. H=R=Q=F=1)
                                                ; under a convex contaminated ErrY (AO) [radius=0.1, K=N(10,0.1)]

;kfilter2
             serie = read("kalman1.dat")
             y = serie[,2]
             mu = 10
             Sig = 0
             H = 1
             F = 1
             Q = 9
             R = 9

             res= kfilter2(y,mu,Sig, H,F,Q,R)
             fx=res.filtX
             fy = (H*fx')'

             fserie = serie[,1]~serie[,2]~fy                        

             data = fserie[,1]~fserie[,2]
             data = setmask(data, "line", "red", "thin")
             fdata = fserie[,1]~fserie[,3]
             fdata = setmask(fdata, "line", "blue", "thin")

             disp = createdisplay(1,1)
             show(disp,1,1, data, fdata)
             setgopt(disp,1,1, "title", "Kalman filter 1")
                                 ;Original serie is displayed with red colour,
                                 ;filtered serie is displayed with blue colour.
                                 ;(y is a lagged random walk with errors.)

;rICfil

             serie = read("kalmanao.dat")
             y = serie[,2]
             mu = 10
             Sig = 0
             H = 1
             F = 1
             Q = 9
             R = 9
             T=dim(y)

             e=0.05
             N=100
             eps=0.01
             itmax=15
             aus=4;; lots of output;; may be set to 0
             fact=1.2
             expl=2
             A0=0     ;; produces default values inside the called quantlets
             b0=-1    ;; produces default values inside the called quantlets 
             typ= 0   ;;   simultaneous clipping

             ergIC=calibrIC(T,Sig,H,F,Q,R,typ,A0,b0,e,N,eps,itmax,expl,fact,aus)
                    ;; gets the clipping heights b and the Lagrange Multiplyers A to efficiency loss e
             
             A=ergIC.A
             b=ergIC.b

             res = kfilter2(y,mu,Sig, H,F,Q,R)
             fx = res.filtX
             res= rICfil(y,mu,Sig,H,F,Q,R,typ,A,b)
             frx = res.filtX
             
             origy= serie[,1]~serie[,2]
             origy= setmask(origy, "line", "blue", "thin")
             fx = serie[,1]~fx
             fx = setmask(fx, "line", "red", "thin")
             frx = serie[,1]~frx
             frx = setmask(frx, "line", "green", "thin")
             clip=serie[,1]~(res.clipInd)
             clip=paf(clip,clip[,2]==1)
             clip[,2]=0
             setmaskp(clip,4, 3, 4)  
             
             disp = createdisplay(1,1)
             show(disp,1,1, origy,fx,frx,clip)
             setgopt(disp,1,1, "title", "KalmanData1 + AO's in t=50,60,90")
             setgopt(disp,1,1, "xlabel", "t") 
             setgopt(disp,1,1, "ylabel", "y, rIC-sim, Kalman") 
                                 ; Serie of observations is displayed with blue colour,
                                 ; Kalman-filtered serie is displayed with red colour,
                                 ; rls-filtered serie is displayed with green colour.
                                 ; The stages rLSfil has clipped at are marked by a flag.

;rlsfil

             y = serie[,2]
             mu = 10
             Sig = 0
             H = 1
             F = 1
             Q = 9
             R = 9
             T=dim(y)

             e=0.05
             N=100
             eps=0.01
            itmax=15
             aus=4   ;lots of output, may be set to 0

             ergLS=calibrLS(T,Sig,H,F,Q,R,e,N,eps,itmax,aus)
                     ; gets the clipping heights to efficiency loss e
             
             b=ergLS.b

             res = kfilter2(y,mu,Sig, H,F,Q,R)
             fx = res.filtX
             res= rlsfil(y,mu,Sig, H,F,Q,R,b)
             frx = res.filtX
             
             origy= serie[,1]~serie[,2]
             origy= setmask(origy, "line", "blue", "thin")
             fx = serie[,1]~fx
             fx = setmask(fx, "line", "red", "thin")
             frx = serie[,1]~frx
             frx = setmask(frx, "line", "green", "thin")
             clip=serie[,1]~(res.clipInd)
             clip=paf(clip,clip[,2]==1)
             clip[,2]=0
             setmaskp(clip,4, 3, 4)  
             
             disp = createdisplay(1,1)
            show(disp,1,1, origy,fx,frx,clip)
             setgopt(disp,1,1, "title", "KalmanData1 + AO's in t=50,60,90")
             setgopt(disp,1,1, "xlabel", "t") 
             setgopt(disp,1,1, "ylabel", "y, rLS, Kalman") 

                          ; Serie of observations is displayed with blue colour,
                          ; Kalman-filtered serie is displayed with red colour,
                          ; rls-filtered serie is displayed with green colour.
                          ; The stages rlsfil has clipped at are marked by a flag.

   endp