proc(y, z, b, c, v, s, a)=kmcont(x, k, t)    
; -----------------------------------------------------------------------
; Library     xclust 
; -----------------------------------------------------------------------
; See_also    kmeans adaptive distance agglom wardcont 
; -----------------------------------------------------------------------
; Macro       kmcont 
; -----------------------------------------------------------------------
; Description performes a K-means cluster analysis of the rows
;             of a contingency table including the multivariate 
;             graphic using the correspondence analysis; makes
;             available the factorial coordinates (scores)
; -----------------------------------------------------------------------
; Usage       ck = kmcont (x, k, t) 
; Input
;   Parameter  x
;   Definition n x p  matrix of n row points to be clustered (the
;                     elements must be >= 0 with positive marginal
;                     sums)
;   Parameter  k 
;   Definition scalar: The number of clusters
;   Parameter  t
;   Definition n x 1  matrix of the true partition (only if known,
;                     else a matrix containing 1) 
;
; Output
;   Parameter  ck.y
;   Definition n x l  matrix: correspondence analysis scores of the
;                     row points (l = min(n-1,p-1)
;   Parameter  ck.z   
;   Definition p x l  matrix: correspondence analysis scores of the
;                     column points
;   Parameter  ck.b
;   Definition n x 1  matrix: Partition of n points into k clusters
;   Parameter  ck.c
;   Definition k x p  matrix of average profiles of clusters
;   Parameter  ck.v
;   Definition k x p  matrix of within cluster inertias divided by
;                     the corresponding weights (masses) of clusters
;   Parameter  ck.s
;   Definition k x 1  matrix of weights (total row profile) of the
;                     rows  
;   Parameter  ck.a
;   Definition p x 1  matrix of weights (inverse total column
;                     profile) of the columns
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             ; generate some data
;             x = #(4, 4, 25, 18, 10)~#(2, 3, 10, 24, 6)~#(3, 7, 12, 033, 7)~#(2, 4, 4, 13, 2)
;             ; generate true partition
;             t  = matrix(5) 
;             ; apply kmcont
;             ck = kmcont(x, 2, t)
; -----------------------------------------------------------------------
; Result      gives a partition gk.b of 5 row points into 3 clusters which
;             minimizes the sum of within cluster inertias
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 950121
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
   n = sum(sum(x,2))                         ; total sum    
   nr = sum(x,2)                             ; marginal sum (rows)   
   nc = sum(x)'                              ; marginal sum (columns)   
   ok = (min(nr)>0) && (min(nc)>0)
   f = matrix(rows(x))   
   cond = 0   
   if(ok)   
      a = n./nc                             ; column weigths   
      m = nr./n                             ; row masses   
      u = x./nr                             ; row profiles   
      q = u.*trans(sqrt(a))                 ; weigthed row profiles   
      while (cond.<0.5)   
         e = ceil(uniform(rows(u)).*k)   
         h = conting(e, f)   
         cond = min(h)                      ; empty classes?   
      endo   
      f = matrix(cols(x))
      {b, c, v, s} = kmeans(q, e, 0, f, m)         ; clustering the rows   
      "Criterium value"
      sum(s'*v)                         ; criterium value   
      w = x./sqrt(nr)   
      u = w./trans(sqrt(nc))   
      g = trans(u)*u   
      {e, bev}=eigsm(g)   
      g = e~trans(bev)   
      g = sort(g, (-1))   
      g = g[2:rows(g),]   
      l = trans(sqrt(g[,1]))   
      r = trans(g[,2:cols(g)]) 
      y = q*r 
      contdisp = createdisplay(3,1)
      r = y[,1:2]
      setmaskp (r, b)
      show(contdisp, 1, 1, r)
      setgopt(contdisp, 1, 1, "contpart") 
      "Quality of axes:"
      g[,1]~(g[,1].*100./sum(g[,1])) 
      q = trans(x)./nc                          ; column profiles 
      z = (q*y)./l 
      p = z[,1:2]
      setmaskp(p, f)
      show(contdisp, 2, 1, p)
      setgopt(contdisp, 2, 1, "contpcac") 
      show(contdisp, 3, 1, r, p)
      setgopt(contdisp, 3, 1, "contboth") 
      "Contingency table true - estimated partition"
      conting(t, b)
   endif
endp
