proc (KP, critvalue)=kpssnum(y,T)
; ----------------------------------------------------------------------
; Library 	  finance
; ----------------------------------------------------------------------
;  See_also	  kpss, rvlm, lo, robwhittle, roblm, lobrob, gph, sclmtest, neweywest
;----------------------------------------------------------------------
;   Macro	  kpssnum
; ----------------------------------------------------------------------
;   Description   Calculation of the KPSS statistics for I(0) against long-memory
;                 alternatives. We consider the two tests, denoted by KPSS_mu and KPSS_t,
;                 and respectively based on a regression on a constant mu, and
;                 on a constant and a time trend t. 
;                 The quantlet returns the value of the estimated statistic for two
;                 type of the tests, i.e., const or trend and
;                 the critical values for a 95 percent confidence interval for I(0) (const, trend). 
;
; ----------------------------------------------------------------------
;   Usage         (kp, critvalue) = kpssnum(y,T)
;   Input 
;     Parameter   y 
;     Definition  vector
;     Parameter   T 
;     Definition  scalar, truncation lag for the autocorrelation consistent variance estimator
;     Output
;     Parameter   kp
;     Definition  vector
;     Parameter   critvalue
;     Definition  vector
; ----------------------------------------------------------------------
;   Example     ;Non-stationarity test on the series dmus58.dat. 
;               library("times")
;               x = read("dmus58.dat") ; 25477 obs: log FX rates
;               x = x[1:1000]
;               kpssnum(x,0) ; 
; ----------------------------------------------------------------------
;   Result
;
;
; ----------------------------------------------------------------------
;   Reference
;       Kwiatkowski,D., Phillips, P.C.B., Schmidt, P., and Y. Shin (1992):
;       Testing the Null Hypothesis of Stationarity Against the Alternative
;       of a Unit Root: How Sure Are We that Economic Series Have a Unit
;       Root, Journal of Econometrics, 54, 159-178.
; ----------------------------------------------------------------------
;  Keywords
;       long memory, tests, nonstationarity
; ----------------------------------------------------------------------
;   Author        Gilles Teyssiere, 980425. Revised 990120
; ----------------------------------------------------------------------
  n = rows(y) 
  rat1 = (n/100)^(0.25)
  bandwidth = rint(T*rat1)
  temps = cumsum(matrix(n))
  ctemps = temps - mean(temps)
  cy = y - mean(y)
  betahat = sum(ctemps.*cy)/sum(ctemps^2)  
  constanthat = mean(y) - betahat*mean(temps)
  e1 = cy
  e2 = y - constanthat -betahat*temps
  S1 = sum(cumsum(e1)^2)
  S2 = sum(cumsum(e2)^2)
  ;;
  KP = matrix(2)
  sac1 = neweywest(e1,bandwidth)
  sac2 = neweywest(e2,bandwidth)
  KP[1] = S1/sac1[1]
  KP[2] = S2/sac2[1]
  KP = KP/(n^2)
  critvalue = #(0.463,0.146)
endp