proc(smootY) = ksmoother(y,mu,Sig,H,F,Q,R)
; -----------------------------------------------------------------
; Library        times
; -----------------------------------------------------------------
;  See_also      kfilter, kem
; -----------------------------------------------------------------
;   Macro        ksmoother
; -----------------------------------------------------------------
;   Description  Calculates a smoothed time serie (uni- or 
;                multivariate) using the Kalman smoother equations.
;                The state-space model is assumed to be in the
;                following form:
;
;                y_t = H x_t + v_t
;
;                x_t = F x_t-1 + w_t
;
;                x_0 ~ (mu,Sig), v_t ~ (0,Q), w_t ~ (0,R)
;
;                All parameters are assumed known.
;
; -----------------------------------------------------------------
;   Keywords     Kalman filter, Kalman smoother, smoother
; -----------------------------------------------------------------
;   Usage         fy = ksmoother(y,mu,Sig,H,F,Q,R)    
;   Input
;     Parameter   y  
;     Definition      T x m matrix of observed time series, 
;                     T is the number of observations,
;                     m is the dimension of time series
;     Parameter   mu    
;     Definition      n x 1 vector, the mean of the initial state
;     Parameter   Sig    
;     Definition      n x n covariance matrix of the initial state
;     Parameter   H    
;     Definition      m x n matrix
;     Parameter   F    
;     Definition      n x n matrix
;     Parameter   Q   
;     Definition      m x m variance-covariance matrix
;     Parameter   R
;     Definition      n x n variance-covariance matrix 
;   Output                                                           
;     Parameter   fy
;     Definition      T x p matrix of filtered time series
; -----------------------------------------------------------------
;   Example   library("xplore")
;             library("times")
;             library("plot")
;
;             serie = read("kalman1.dat")
;             y = serie[,2]
;             mu = 10
;             Sig = 0
;             H = 1
;             F = 1
;             Q = 9
;             R = 9
;
;             sy = ksmoother(y,mu,Sig,H,F,Q,R)
;
;             sserie = serie[,1]~serie[,2]~sy                        
;
;             data = sserie[,1]~sserie[,2]
;             data = setmask(data, "line", "red", "thin")
;             sdata = sserie[,1]~sserie[,3]
;             sdata = setmask(sdata, "line", "blue", "thin")
;
;             disp = createdisplay(1,1)
;             show(disp,1,1, data, sdata)
;             setgopt(disp,1,1, "title", "Kalman smoother 1")  
; -----------------------------------------------------------------
;   Result    Original serie is displayed with red colour,
;             filtered serie is displayed with blue colour.
;             (y is a lagged random walk with errors.)
; -----------------------------------------------------------------
;   Example   library("xplore")
;             library("times")
;             library("plot")
;
;             serie = read("kalman3.dat")
;             y  = serie[,2:3] 
;             mu = #(20,0)
;    
        Sig = #(0,0)~#(0,0)
;             H  = #(0.3,-0.3)~#(1,1)
;             F  = #(1,0)~#(1,0)
;             Q  = #(9,0)~#(0,9)
;             R  = #(0,0)~#(0,9)
;
;             sy = ksmoother(y,mu,Sig,H,F,Q,R)
;
;             sserie = serie[,1]~serie[,2]~serie[,3]~sy[,1]~sy[,2]
;
;             data1 = sserie[,1]~sserie[,2]
;             data1 = setmask(data1, "line", "red", "thin")
;
;             sdata1 = sserie[,1]~sserie[,4]
;             sdata1 = setmask(sdata1, "line", "blue", "thin")
;
;             data2 = sserie[,1]~sserie[,3]
;             data2 = setmask(data2, "line", "red", "thin")
;
;             sdata2 = sserie[,1]~sserie[,5]
;             sdata2 = setmask(fdata2, "line", "blue", "thin")
;
;             disp = createdisplay(2,1)
;             show(disp,1,1, data1, sdata1)
;             setgopt(disp, 1, 1, "title", "Kalman smoother 2 - 1st element")
;             show(disp,2,1, data2, fdata2)
;             setgopt(disp,2,1, "title", "Kalman smoother 2 - 2nd element")
; -----------------------------------------------------------------
;   Result    Original serie is displayed with red colour,
;             filtered serie is displayed with blue colour.
;             (y is a lagged bivariate MA process with errors.)
; -----------------------------------------------------------------
;   Example   library("xplore")
;             library("times")
;             library("plot")
;
;             serie = read("kalman2.dat")
;             y = serie[,2]
;             mu = #(0,0)
;            
Sig = #(0,0)~#(0,0)
;             H = #(1,0)'
;             F = #(0.5,1)~#(-0.3,0)
;             R = #(1,0)~#(0,0)
;             Q = 4
;             fy = ksmoother(y,mu,Sig,H,F,Q,R)
;
;             sserie = serie[,1]~serie[,2]~sy
;
;             data1 = sserie[,1]~sserie[,2]
;             data1 = setmask(data1, "line", "red", "thin")
;
;             sdata1 = sserie[,1]~sserie[,3]
;             sdata1 = setmask(sdata1, "line", "blue", "thin")
;
;             disp = createdisplay(1,1)
;             show(disp,1,1, data1, fdata1)
;             setgopt(disp,1,1, "title", "Kalman smoother 3")
; -----------------------------------------------------------------
;   Result    Original serie is displayed with red colour,
;             filtered serie is displayed with blue colour.
;             (y is an AR(2) process with errors.)
; -----------------------------------------------------------------
;   Author    P.Franek 990507
; -----------------------------------------------------------------
  
  filtered = kfilter(y,mu,Sig,H,F,Q,R)          ; prirazuji jen kvuli potlaceni vystupu
  KFOutPut = read("KFOutPut.dat")               ; prepare the matrix of x_t|t and P_t|t
  
  dimX = rows(mu)                                ; dimense x => kazdy radek OutPut ma dimX + dimX^2 policek 
                                                 ; pozor, KFOutPut ma o jedno pozorovani vice 
  
  T = rows(y)                                    ;get number of observation
  smootY = y .* 0                                ;prepare the result matrix 
  
  CurrentX = (KFOutPut[T+1,1:dimX])'
  CurrentP = reshape(KFOutPut[T+1,dimX+1:dimX+dimX^2],#(dimX,dimX))
  
  KSOutPut = vec(CurrentX,vec(CurrentP))
  
  smootY[T,] = H * CurrentX
  
  PreviousX = CurrentX
  PreviousP = CurrentP
  
  i = T 
  while (i>=1)                                  ;technical note: i=1 corresponds to t=0  
    
; Step of the Kalman recursion
    
    X = KFOutPut[i+1,1:dimX]'                       
    P = reshape(KFOutPut[i+1,dimX+1:dimX+dimX^2],#(dimX,dimX))     ; get x_i|i and P_i|i 
    
    pom = F * P * F' + R
    pominv = ginv(pom)
    PStar = P * F' * pominv                          
    CurrentX = X + PStar * (PreviousX - F * X)     
    CurrentP = P + PStar * (PreviousP - pom) * PStar'  
    
; Step of the loop  
    
    smootY[i,] = (H * CurrentX)' 
    PreviousX = CurrentX
    PreviousP = CurrentP 
    
    KSOutPut = vec(PreviousX,vec(PreviousP))~KSOutPut
    
    i = i-1 
  endo

  KSOutPut = KSOutPut'
  write(KSOutPut,"KSOutPut.dat","x")

endp
