proc(opt)=linregopt(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10)
; -----------------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------------
; See_also     linregbs, linregfs2, linregstep
; -----------------------------------------------------------------------
; Macro        linregopt
; -----------------------------------------------------------------------
; Description  sets optional parameters for linregbs, linregfs2 and
;              linregstep
; -----------------------------------------------------------------------
; Usage        opt = linregopt (s1 {, s2{, s3, ... {,s10} }})
; Input        
;   Parameter  s1, s3, s5, s7, s9
;   Definition string
;   Parameter  s4, s2, s6, s8, s10
;   Definition numerical values
; Output       
;   Parameter  opt
;   Definition list of optional parameters
; -----------------------------------------------------------------------
; Notes        The order of the optional parameters does not play
;              any role. 
;
;              The following string values can be used:
;
;              mode     set "mode" = 1 if you want to choose the parameters
;                       interactively
;
;              Fin      minimum acceptable value to enter into the model         
;                       (F-to-enter), has to be > Fout 
;
;              Fout     maximium acceptable value to remove from the model 
;                       (F-to-remove ), has to be < Fin
;              
;              entry    significance level alpha for entry
;                       (probability of F-to-enter), has to be < out        
;
;              out      significance level alpha for removal
;                       (probability of F-to-remove), has to be > entry 
;  
;
; ----------------------------------------------------------------------
; Example      loads the libraries stats and glm
;              library ("stats")
;              ; load the boston housing data
;              x = read ("bostonh")
;              y = x[,14]
;              x = x[,1:13]
;              ;choose name for independent variables
;              colname=string("X %2.0f",1:rows(x))
;              ; generate some optional parameters
;              opt = linregopt ("Fin", 4.0, "Fout", 3.9)
;              ; set F values
;              {b,bse,bstan,bpval}=linregstep(x,y,colname,opt)
; -----------------------------------------------------------------------
; Result       produces an optional parameters and uses them in linregstep 
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 980211; Kerstin Zanter 980331         
; -----------------------------------------------------------------------
  t = exist("s1")|exist("s2")|exist("s3")| exist("s4")|exist("s5")|exist("s6")
  t = t|exist("s7")|exist("s8")|exist("s9")|exist("s10")
  error (t[1]==0, "linregopt: no parameter given")
  l = list(s1)
  i = 1
  while (i<rows(t))
    i = i+1
    if (t[i])
      cmd = string ("append(l, s%.0f)", i)
      exec (cmd)
    endif
  endo
  i = 0
  mode = 0
  Fin  = NaN
  Fout = NaN
  entry= NaN
  out  = NaN
  opt = list (mode,Fin,Fout,entry,out)
  while (i<rows(t))
    i = i+1
    if ((t[i]==2) && (t[i+1]==1))
      cmd = string ("opt.%s = ", l{i})
      cmd = cmd + string ("s%.0f", i+1)
      exec (cmd)
    endif 
  endo
  if((opt.Fin<>NaN)&&(opt.Fout<>NaN))
    error(opt.Fin <= opt.Fout, "Fin <= Fout")
  endif
  if((opt.entry<>NaN)&&(opt.out<>NaN))
    error(opt.entry >= opt.out, "alpha for entry >= alpha for removal")
  endif
endp
