proc(hrot)=lpregrot(x,p)
; -----------------------------------------------------------------
; Library        smoother
; -----------------------------------------------------------------
;  See_also      lpregest
; -----------------------------------------------------------------
;   Keywords     kernel smoothing, kernel regression estimation, 
;                bandwidth selection, local polynomial regression
; -----------------------------------------------------------------
;   Macro        lpregrot
; -----------------------------------------------------------------
;   Description  determines a rule-of-thumb bandwidth for univariate 
;                local polynomial kernel regression using the
;                Quartic kernel.
; -----------------------------------------------------------------
;   Reference    Fan and Gijbels (1995): Local Polynomial Fitting
; -----------------------------------------------------------------
;   Usage        hrot = lpregrot(x {,p})
;   Input
;     Parameter  x  
;     Definition   n x 2 vector, the data.  
;     Parameter  p
;     Definition   odd integer <=7, order of polynomial. If not 
;                  given, p=1 (local linear) is used. 
;   Output
;     Parameter  hrot
;     Definition   scalar, rule-of-thumb bandwidth.
; -----------------------------------------------------------------
;   Notes     Internally, the Quartic kernel is used for all
;             computations. If a different kernel function K is
;             given as input, the asymptotical equivalent
;             bandwidth for K is calculated via the canonical 
;             kernel approach.
; -----------------------------------------------------------------
;   Example   library("smoother")
;             x=read("nicfoo")
;             hrot=lpregrot(x)
;             hrot
; -----------------------------------------------------------------
;   Result    Contents of hrot
;             [1,]  0.41215 
;-----------------------------------------------------------------
;   Author    Marlene Mueller, 990413
; ----------------------------------------------------------------- 
  if (exist(p)==0)
    p=1
  endif
  if (exist(p)==1)
    error((p>7)||((p%2)==0),"lpregrot: p must be odd and <= 7")
  endif
;
  c = 2.03617|0|3.63335|0|5.15811|0|6.65921  
  n = rows(x)
  xx=matrix(n,1)  
  j=1
  while (j.<=p+3)  
    xx=xx~x[,1]^j  
    j=j+1  
  endo
;  
  al=gls(xx,x[,2])                           ; polyn. fit of order p+3  
  rotsig=(x[,2]-xx*al)'*(x[,2]-xx*al)./n     ; variance estimate  
  dx=max(x[,1])-min(x[,1])  
  il=min(x[,1])+0.15*dx  
  iu=min(x[,1])+0.85*dx  
  intu=lprotint(iu,al,p)  
  intl=lprotint(il,al,p)  
  introt=intu-intl  
  hrot=((iu-il)*rotsig)/(n*introt)  
  hrot=c[p]*hrot^(1/(2*p+3))                 ; rule-of-thumb bandwidth  
endp   
