proc(ft)=lprotint(t, a, p)  
                                               
; -----------------------------------------------------------------
; Library        smoother
; -----------------------------------------------------------------
;  See_also      lpregauto lpderauto

; -----------------------------------------------------------------
;   Macro        lprotint
; -----------------------------------------------------------------
;   Description  lprotint computes the integral of the (p+1)st 
;                derivative of a polynomial of order (p+3), this 
;                function is used to find rule-of-thumb bandwidth 
;                for local polynomial regression and derivative 
;                estimation                     
; -----------------------------------------------------------------
;   Usage        y = lprotint (t, a, p)
;   Input
;     Parameter  t 
;     Definition scalar (argument)
;     Parameter  a  
;     Definition (p+4) x 1 vector (coefficients of polynomial)
;     Parameter  p 
;     Definition integer 
;   Output
;     Parameter  y  
;     Definition scalar (value of integral)
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 941129 & Lijian Yang, 960211   
; -----------------------------------------------------------------

  a1=a[p+2]*prod(aseq(1,p+1,1))  
  a2=a[p+3]*prod(aseq(1,p+2,1))  
  a3=a[p+4]*0.5*prod(aseq(1,p+3,1))  
  ft= a1*a1*t + a1*a2*t^2 + (a2*a2+2*a1*a3)*t^3/3 
  ft= ft + a2*a3*t^4/2 + a3*a3*t^5/5 

endp 
