proc()=modelci(typ,ytt,header,outp,y)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     domulti 
; -----------------------------------------------------------------
;   Macro        modelci
; -----------------------------------------------------------------
;   Description  general analysis for cointegration
; -----------------------------------------------------------------
;   Usage        modelci(typ, ytt, header, outp,y)  
;   Input
;     Parameter   typ  
;     Definition      1,2 or 3, giving the type of model: 1=Full,
;                     2=Subset, 3=Reduced Rank
;     Parameter   ytt 
;     Definition      k x n matrix, the transformed (and transposed) 
;                     time series  
;     Parameter   header
;     Definition      list of 7 objects:   natlog,diff,origyear,
;                     periodicity,origperiod,name,exclude
;     Parameter   outp
;     Definition      integer, (1=output to file, 0 = no output)
;     Parameter   y 
;     Definition      k x n matrix, the original time series
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich 971215
; -----------------------------------------------------------------
    di=rows(ytt)
    infotran=(1:di) ~ (header.diff*2-1) ~ (header.natlog*2-1)
    r=readvalue("Order"|"Rank"|"Beginning of sample"|"End of sample", 1|1|2|cols(ytt))
    ord=r[1]
    rk=r[2]
    tb=r[3]
    te=r[4]
    t=te-tb+1
    adj=0
    error(tb-ord<1, "Check beginning of sample!")
    dy=itediff(ytt,1)
    yp=ytt[,tb-ord:te-ord]
    dy2=dy[,tb:te]
    {ev,ew} = evci(yp,dy,ord,tb,te,t,di)
    c=ev[,1:rk]'
    eigval=ew
    d=dgenci(dy,yp,ord,c,tb,te,di);
    g=gammaci(dy,yp,d,c,ord,tb,te,di);
    f=fgenci(di,ord);
    b=(g~-d*c)*f+jbgen(di,ord);
    r=rootsci(ord,di,tb,te,typ,ytt)
    covu=sijci(ytt,dy,ord,tb,te,t,di,0,0)-d*d';
    ok=covcheck(covu);
    if (ok==1)
      om=omgenci(yp,c,ord,dy,tb,te,t,di);
      sfb=(reshape(xdiag(fncovci(f,covu,om,c,di,ord,rk)),di|di*ord+1)/t)^.5;
    endif;
    headline=" Menu: Results of Cointegration VAR estimation" 
     items = " Coefficients (standard errors)" | " Coefficients (t-ratios)"  
     items = items| " Residual Covariance Matrix" | " Residual Analysis"
     items = items| " Reverse Characteristic Roots" | " ML Eigenvalues" 
     items = items| " Cointegration Matrix" | " Loading Matrix" 
     items = items| " Cointegration tests" | " Forecasting"|" Quit to main menu"
     do
     is=selectitem(headline, items,"single") 
    switch
    case (is[1,] == 1)  
        dummy = createdisplay(ord+1,1)
        str=string("  %5.2f",b[,1])+string(" (%5.2f)",sfb[,1])
        str="  Intercept  (standard errors in parentheses)"|" "|str
        show(dummy,1,1,str)
        if (outp==1)
          "Cointegration"
          str
        endif
        j=1
        while(j<=ord)
         str=string("  %5.2f",b[,(j-1)*di+2])+string(" (%5.2f)",sfb[,(j-1)*di+2])
         i=3
         while(i<=di+1)
          str=str+(string("  %5.2f",b[,(j-1)*di+i]))
          str=str+(string(" (%5.2f)",sfb[,(j-1)*di+i]))
          i=i+1
         endo
         str=string("   A%1.0f",j)|" "|str
         show(dummy,j+1,1,str)
         if (outp==1)
           str
         endif
         j=j+1
        endo
    case (is[2,] == 1)
        dummy = createdisplay(ord+1,1)
        str=string("  %5.2f",b[,1])+string(" (%5.2f)",b[,1]./sfb[,1])
        str="  Intercept  (t-ratios in parentheses)"|" "|str
        show(dummy,1,1,str)
        if (outp==1)
          "Cointegration"
          str
        endif
        j=1
        while(j<=ord)
         str=string("  %5.2f",b[,(j-1)*di+2])+string(" (%5.2f)",b[,(j-1)*di+2]./sfb[,(j-1)*di+2])
         i=3
         while(i<=di+1)
          str=str+(string("  %5.2f",b[,(j-1)*di+i]))
          str=str+(string(" (%5.2f)",b[,(j-1)*di+i]./sfb[,(j-1)*di+i]))
          i=i+1
         endo
         str=string("   A%1.0f",j)|" "|str
         show(dummy,j+1,1,str)
         if (outp==1)
           str
         endif
         j=j+1
        endo
        break 
case (is[3,] == 1)
      dummy=createdisplay(1,1)
      str=string("%5.2e",covu[,1])
      i=2
      while(i<=di)
          str=str+string("  %5.2e",covu[,i])
          i=i+1
      endo
      str1 = "Covariance Matrix of Residuals"
      str2 = "Determinant = " + string("  %5.2f",det(covu))
      str = str1 | str2 | " " | str
      show(dummy,1,1,str)
      if (outp==1)
        "Cointegration"
        str
      endif
      break
; Residual analysis   
; -----------------------------------------------------------------------------
case (is[4,] == 1)
      u=residuen(b,ord,di,adj,tb,te,ytt)
  noquit = 1
  noback=1
  while (noquit && noback)
    head = " Residual Analysis"
    item = " Individual Residual Series Analysis "
    item = item|" Multivariate Portmanteau statistic"
    item = item | " Multivariate normality tests"
    item = item|" Back"
    stat = selectitem(head,item,"single")'*(1:rows(item))
      
    switch
    case (stat==1)
       
    head = " Select time series "
    item = string(" ",1:di)+header.name+string("                ",1:di)
    item = substr(item,1,16)
    logstr = string("   ",1:di)
 
    item = item |" Back"
    tseries = selectitem(head,item,"single")'*(1:rows(item))
    if (tseries==0||tseries==rows(item))
      noquit = 0
      noback = 0
    endif
    while (noback)
    head = " Select desired transformation "
    item = " Residuals" | " Absolute residuals" | " Squared residuals"
    tr = selectitem(head,item,"single")'*(1:rows(item))
    switch
    case (tr==1)
        r = u'
        item2= " residuals" break
    case (tr==2)
        r = abs(u)'
        item2= " absolute residuals" break
    case (tr==3)
        r = (u.^2)'
        item2= " squared residuals"  break
    case (tr==0 || tr == rows(item))
        noback=0
    endsw
      while (noback)
      head = header.name[tseries]
      item = (" Plot of"+item2)|(" ACF of"+item2)
      item = item|(" PACF of"+item2)
      item = item|(" Periodogram of"+item2)
      item = item|" Spectral density estimation"
      item = item|" Back to results menu"
      resid = selectitem(head,item,"single")
      switch
        case (resid[1])
        header[tseries]
          dummy=timeplot(r[,tseries],400,header)
          break
        case (resid[2])
          dummy=acfplot(r[,tseries])
          if (outp==1)
              "ACF of"+item2+" of "+head
              acf(r[,tseries]) 
          endif
          break
        case (resid[3])
          dummy=pacfplot(r[,tseries])
          if (outp==1)
              "PACF of"+item2+" of "+head
              pacf(r[,tseries],30) 
          endif
          break
        case (resid[4])
          pg = pgram(r[,tseries])
          if (outp==1)
              "Periodogram of"+item2+" of "+head
              pg 
          endif
          break
        case (resid[5]) 
          sp = spec(r[,tseries])
          if (outp==1)
              "Spectral density estimate of"+item2+" of "+head
              sp
          endif
          break       
        case (resid[6])
          noback = 0
      endsw
      endo
    endo
    dummy  = 0
    dpgram = 0
    dspec  = 0
    break
    case (stat==2)      
          h=readvalue("Up to which lag should be tested?", 10)
          dummy=portmant(b,0,tb,te,t,di,ord,adj,h,di*di*(h-ord),typ,ytt,outp)
          break    
    case (stat==3)      
          dummy=normalt(t,di,ord,covu,u,outp)
          break
    case (stat==4)
          noback=0
    endsw
    endo
  break
case (is[5,])
      dummy=createdisplay(1,1)
      str=string("%5.2f",r)
      str1 = "Characteristic roots of VAR operator"
      str = str1 |" " | str
      show(dummy,1,1,str)
      if (outp==1)
        "Characteristic roots of VAR operator"
        str
      endif
      break
case (is[6,])
      dummy=createdisplay(1,1)
      str=string("%5.2f",eigval[,1])
      i=2
      while(i<=rk)
          str=str+string("  %5.2f",eigval[,i])
          i=i+1
      endo
      str1 = "Eigenvalues (lambda) for cointegration analysis"
      str = str1 |" " | str
      show(dummy,1,1,str)
      if (outp==1)
        "ML Eigenvalues"
        str
      endif
      break
case (is[7,])
      dummy=createdisplay(1,1)
      str=" "
      i=1
      while(i<=rk)
      str1=string("%5.2f",c[i,1])
      j=2
      while(j<=di)
          str1=str1+string("  %5.2f",c[i,j])
          j=j+1
      endo
      str=str|str1
      i=i+1
      endo
      str2 = "Cointegration Matrix"
      str = str2 |" " | str
      show(dummy,1,1,str)
      if (outp==1)
        "Cointegration Matrix"
        str
      endif
      break
case (is[8,])
      dummy=createdisplay(1,1)
      str=string("%5.2f",d[,1])
      i=2
      while(i<=rk)
          str=str+string("  %5.2f",d[,i])
          i=i+1
      endo
      str1 = "Loading Matrix"
      str = str1 |" " | str
      show(dummy,1,1,str)
      if (outp==1)
        "Loading Matrix"
        str
      endif
      break
case (is[9,])
      ewt = -t*log(1-rev(ew[max(di-10|1):di,]))
      tests = "H_0: rank<=r, H_1: rank = dim (rank test)"
      tests = tests | "H_0: rank<=r, H_1: rank = r+1 (maximum eigenvalue test)"
      tests = tests | "Back to cointegration results"
      noback=1
      while (noback)
      seltest=selectitem(" Please select",tests,"single")
      switch 		
      case (seltest[1])
          n1=#(6.5,15.66,28.71,45.23,66.49,90.39,118.99,151.38,186.54)
          n1=n1~#(8.18,17.95,31.53,48.28,70.04,95.18,124.25,157.25,192.84)
          n1=n1~#(9.72,20.08,34.48,51.54,74.04,99.32,129.76,162.75,198.06)
          n1=n1~#(11.65,23.52,37.22,55.43,78.87,104.20,136.06,168.92,204.79)
          dummy = createdisplay(2,1)
	  lr = cumsum(ewt)
          str="Trace Test for Cointegration Rank" | " "
          str=str|" H_0: rank=r, H_1: rank=K"| " "
          str=str|"             Asymptotic distribution"
          str2=" r" + "  lambda" + "     90%" + "    95%" + "  97.5%" + "    99%"
          str1=string("%2.0f",aseq(di-1,di,(-1)))
          str1=str1+ "  " +string("%5.2f",lr)
          str1=str1+ "    " +string("%5.2f",n1[1:di,1])
          str1=str1+ "  " +string("%5.2f",n1[1:di,2])
          str1=str1+ "  " +string("%5.2f",n1[1:di,3])
          str1=str1+ "  " +string("%5.2f",n1[1:di,4])
          str = str | str2 | " " | str1
	  show(dummy,1,1,str)
          str3="K: dimension"
          str3=str3|"lambda(r,K): likelihood ratio test statistic"|" "
          str3=str3|"Source: Osterwald-Lenum, A Note with Quantiles ..., "
          str3=str3|"Oxford Bulletin of Economics and Statistics, 54,3 (1992)"
	  show(dummy,2,1,str3)
      case (seltest[2])
          n2=#(6.50,12.91,18.90,24.78,30.84,36.35,42.06,48.43,54.01,59.19)
          n2=n2~#(8.18,14.90,21.07,26.14,33.32,39.43,44.91,51.07,57.00,62.42)
          n2=n2~#(9.72,17.07,22.89,29.16,35.79,41.86,47.59,53.85,59.80,64.98)
          n2=n2~#(11.65,19.19,25.75,32.14,38.78,44.59,51.30,57.07,63.37,68.61)
          dummy = createdisplay(2,1)
	  lr = ewt
          str="Maximum Eigenvalue Test for Cointegration Rank" | " "
          str=str|" H_0: rank=r, H_1: rank=r+1"| " "
          str=str|"             Asymptotic distribution"
          str2=" r" + "  lambda" + "     90%" + "    95%" + "  97.5%" + "    99%"
          str1=string("%2.0f",aseq(di-1,di,(-1)))
          str1=str1+ "  " +string("%5.2f",lr)
          str1=str1+ "    " +string("%5.2f",n2[1:di,1])
          str1=str1+ "  " +string("%5.2f",n2[1:di,2])
          str1=str1+ "  " +string("%5.2f",n2[1:di,3])
          str1=str1+ "  " +string("%5.2f",n2[1:di,4])
          str = str | str2 | " " | str1
	  show(dummy,1,1,str)
          str3="lambda(r,K): likelihood ratio test statistic"|" "
          str3=str3|"Source: Osterwald-Lenum, A Note with Quantiles ..., "
          str3=str3|"Oxford Bulletin of Economics and Statistics, 54,3 (1992)"
	  show(dummy,2,1,str3)	
      case (seltest[rows(seltest)]==1)
	  noback=0
	  break
      endsw
      endo	
;
;  Forecasting
;  -----------------------------------------------------------------------
  case(is[10])
     covb=fncovci(f,covu,om,c,di,ord,rk)
     if (sum(header.diff)>0)
          head="Forecasting..."
          item="variables"
          item=item|"undifferenced variables"   
          choice=selectitem(head,item,"single")
      if (choice[1]==1)
       forecast(b,covb,covu,ord,0,tb,te,ytt,typ,header,outp)
      else 
       forec2(b,covb,covu,ord,0,tb,te,y,ytt,typ,infotran,header,outp)
      endif
     else
      forecast(b,covb,covu,ord,0,tb,te,ytt,typ,header,outp)
     endif
    break
  endsw
  until (is[rows(is)])
  noquit=0
dummy=0
endp
