proc(r)=multitest()
; -----------------------------------------------------------------
; Library       multi
; -----------------------------------------------------------------
;  See_also     domulti
; -----------------------------------------------------------------
;   Macro       multitest
; -----------------------------------------------------------------
;   Description  executes some tests for the quantlets defined
;                in multi.lib. Is invoked by vertestl().
; -----------------------------------------------------------------
;   Usage        multitest()
;   Input
;     Parameter   
;     Definition        none     
;   Output
;     Parameter  r
;     Definition        0 if test was o.k., 1 otherwise     
; -----------------------------------------------------------------
;   Example   library("multi") 
;             multitest()
; -----------------------------------------------------------------
;   Result    Contents of r
;             [1,]     0 
; -----------------------------------------------------------------
;   Author    Christian Hafner, 980428
; -----------------------------------------------------------------
r=0
// -------------------------------------------
"sigma1"
h=mean(sigma1(matrix(3,2),1,4))
h=(abs(h[1,1]-5)>1)
r=r || h
// -------------------------------------------
// power 970804
"power"
h=power(1,2)
h=abs(h-1)>1
r=r||h
// -------------------------------------------
// hgen 970804
"hgen"
h=hgen(1,1)
h=(abs(h[1,1])>1)
r=h||r
// -------------------------------------------
// phigen 970731
"phigen"
h=phigen(2,2,2,2,1,1)
h=abs(h[1,1]-1)>1
r=h||r
// -------------------------------------------
// bgen 970731
"bgen"
h=bgen(zeros(1,2),1,1)
h=abs(h[1,1]-1)>1
r=h||r
// -------------------------------------------
"jbgen"
h=jbgen(1,1)
h=abs(h[1,1])>1
r=h||r
// -------------------------------------------
// jagen 970731
"jagen"
h=jagen(1,1,1)
h=abs(h-1)>1
r=r||h
// -------------------------------------------
// agen 970731
"agen"
h=agen(1,1,1,1)
h=abs(h-1)>1
r=h||r
// -------------------------------------------
// aorBgen 970731
"aorBgen"
h=aorBgen(1,1,1,1,1)
h=abs(h-1)>1
r=h||r
// -------------------------------------------
// jotaAorB 970804
"jotaAorB"
h=jotaAorB(1,1,1,1)
h=abs(h-1)>1
r=h||r
// -------------------------------------------
// covmwgen 970804
"covmwgen"
h=covmwgen(1,1,1,1,0,1,1)
h=abs(h)>1
r=h||r
// -------------------------------------------
// covcheck 970804
"covcheck"
h=covcheck(eye(2))
h=abs(h-1)>1
r=h||r
// -------------------------------------------
// covres 970804
"covres"
h=covres(1,1,2,1,1,1,1:2)
h=h[1,1]
h=(h!=NaN)
r=h||r
// -------------------------------------------
// omerrgen 970804
"omerrgen"
h=omerrgen(1,1,1,1,1,1,1,2,2,1,1,1)
h=abs(h)>1
r=h||r
// --------------------------------------------
// coeffba 970805
"coeffba"
h=coeffba(1,1,1,1,1,1,1,1,1,1,1)
h=abs(h[1,1])>1
r=h||r
// --------------------------------------------
// sfvonmw 970805
"sfvonmw"
h=sfvonmw(1,1,1,0,1)
h=abs(h-1)>1
r=h||r
// --------------------------------------------
// coeffest 970805
"coeffest"
h=coeffest(0,1,1,1,1,1,1)
h=abs(h)>1
r=h||r
// --------------------------------------------
// sfcoeff 970805
"sfcoeff"
h=sfcoeff(0,1,1,1,1,1,1)
h=abs(h)>1
r=h||r
// --------------------------------------------
endp