proc(delta,delta1,dvar)=newadeslp(x,y,h)
; -----------------------------------------------------------------
; Library        metrics
; -----------------------------------------------------------------
;  See_also      adeind wtsder trimper dwade
; -----------------------------------------------------------------
;   Macro        newadeslp
; -----------------------------------------------------------------
;   Keywords     single index model, semiparametric estimation, 
;                average derivative
; -----------------------------------------------------------------
;   Description   slope estimation of average derivatives 
;                            
; -----------------------------------------------------------------
;   Reference    Stoker (1991), "Equivalence of direct, indirect, and 
;                slope estimators of average derivatives", 
;                in: Nonparametric and semiparametric methods in 
;                econometrics and statistics; 
;                Barnett, Powell and Tauchen (eds.),Cambridge University Press
; -----------------------------------------------------------------
;   Usage        {delta,delta1,dvar} = newadeslp(x,y,h)    
;   Input
;     Parameter   x  
;     Definition      n x p matrix , the observed explanatory variable    
;     Parameter   y 
;     Definition      n x 1 matrix , the observed response variable  
;     
;     Parameter   h
;     Definition      p x 1 vector or scalar , the bandwidth to be used during estimation of the scores
;   Output                                                           
;     Parameter   delta 
;     Definition      p x 1 vector , the indirect slope estimate
;     Parameter   delta1 
;     Definition      p x 1 vector , the indirect ADE
;     Parameter   dvar
;     Definition      p x p matrix , the estimated asymptotic 
;                                    covariance of delta1  
; -----------------------------------------------------------------
;   Example   library("metrics")
;             n   = 100
;             x   = normal(n,3)
;             z   = 0.2*x[,1] - 0.7*x[,2] + x[,3]
;             eps = normal(n,1) * sqrt(0.5)
;             y   = 2 * z^3 + eps
;             h   = 5
;             {delta,delta1,dvar} = newadeslp(x,y,h)              
;             delta
;             delta1
;             dvar
; -----------------------------------------------------------------
;   Result    the slope estimator for average derivatives and its 
;             asymptotic covariance matrix  as described by
;             Stoker in Barnett, Powell, Tauchen, "Nonparametric and
;             Semiparametric Methods in Econometrics and Statistics"
;             (1991)          and Turlach, Discussion Paper (1993)
; -----------------------------------------------------------------
;   Author    Rinaldo Brau 99.12.10, Sperlich 00.1.19 
; -----------------------------------------------------------------
  error(rows(x)!=rows(y),"x and y have different number of rows")
  error(cols(y)!=1 ,"y has more than one column")
  p=cols(x)
  n = rows(x)
  if ( rows(h) .< p ) 
    h = matrix(p).*h
  endif 

;Estimation of densities
Pn = matrix(n)
uv = sort(x~Pn~y,1)
       x = uv[,1:p]
       y = uv[,p+2]
  fh = sker(x,h',"qua",Pn)
        Gh = sker(x,h',"qua",y)
        
;       Estimation of fhder 
        fhder   = matrix(n,p)
        i    = 1
        WHILE (i<= p)   
        j    = 1
  WHILE (j<= n)
        Pn = matrix(n,p)
        XX = x[j,]
        X = XX.*Pn
        u = (X-x)/h'
        pker = 0.9375.*((1-(u)^2)^2 ).*(abs(u).<1)
        pker[,i] = -3.75 .*(u[,i]) .*(1-(u[,i])^2) .*(abs(u[,i]).<1)
        prker = prod(pker,2)
        fhder[j,i] = sum(prker)/(n.*prod(h).*h[i,])

j=j+1
ENDO

i=i+1
ENDO

; trimming
        fhtrim = sort(fh)
        thsold = fhtrim[0.05.*n,]
        xy = x~y
        xy = paf(xy,fh>thsold)
        fhder = paf(fhder,fh>thsold)
        Gh = paf(Gh,fh>thsold)
        fh = paf(fh,fh>thsold)
        x = xy[,1:p]
        y = xy[,p+1]
        nn = rows(x)

;       Estimating Ghder
Ghder   = matrix(nn,p)
        i    = 1
        WHILE (i<= p)   
        j    = 1
  WHILE (j<= nn)
        
        Pn = matrix(nn,p)
        XX = x[j,]
        X = XX.*Pn
        u = (X-x)/h'
        pker = 0.9375.*((1-(u)^2)^2 ).*(abs(u).<1)
        pker[,i] = -3.75 .*(u[,i]) .*(1-(u[,i])^2) .*(abs(u[,i]).<1)
        prker = prod(pker,2).*y
        Ghder[j,i] = sum(prker)/(n.*prod(h).*h[i,])

j=j+1
ENDO

i=i+1
ENDO


gh=Gh/fh                ;Naradaya-Watson

        lh = -fhder/fh                  ;computing scores
        ghder = (Ghder/fh)+(gh.*lh)     ;computing derivatives

  lhbar = sum(lh)/nn
  xbar  = sum(x)/nn
        ybar  = sum(y)/nn
        slx = (lh'*x)/nn - (lhbar'*xbar)
        slxi  = inv(slx)
        sly = (lh'*y)/nn - (lhbar'.*ybar)
  delta = slxi*sly
        delta1= lh.*y
        delta1 = (sum(delta1)/n)'
;

; asymptotic variance
        rh=(lh.*y)+(ghder-(lh.*gh))

;rh = ghder+((y-gh).*lh)
  rhbar = sum(rh)/n
        dvar = cov(rh)/n
;       dvar = ((rh'*rh)/n - (rhbar'*rhbar))/n
endp