proc (sigma2) = neweywest (y,m)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  rvlm, kpss, lo 
;----------------------------------------------------------------------
;   Macro	  neweywest
; ----------------------------------------------------------------------
;   Description   Calculation of the Newey and West Heteroskedastic and 
;                 Autocorrelation Consistent estimator of the variance.
;                 The first argument of the quantlet is the series, the second 
;                 optional argument is the vector of truncation lags of the 
;                 autocorrelation consistent variance estimator. If the second
;                 optional argument is missing, the vector of truncation lags 
;                 is set to m = 5, 10, 25, 50. 
;  
; ----------------------------------------------------------------------
;   Usage         q = neweywest(y{,m})
;   Input 
;     Parameter   y 
;     Definition  vector
;     Parameter   m
;     Definition  vector
;   Output
;     Parameter   q
;     Definition  vector
; ----------------------------------------------------------------------
;   Example    ;Calculation of the Newey and West variance estimator of 
;              ;the first 1000 observations of the series dmus58.dat
;              ;This estimator is calculated for the default truncation 
;              ;orders m = 5, 10, 25, 50
;               library("times")
;               x = read("dmus58.dat")
;               x = x[1:1000]
;               q = neweywest(x)
;               q
; ----------------------------------------------------------------------
;   Result
;               Contents of q
;
;              [1,]  0.0022226 
;              [2,]  0.0040569 
;              [3,]  0.0094627 
;              [4,]  0.018105 
; ----------------------------------------------------------------------
;   Example    ;Calculation of the Newey and West variance estimator of 
;              ;the first 1000 observations of the series dmus58.dat
;              ;This estimator is calculated for the vector of truncation 
;              ;orders m = 10, 15, 20 provided by the user.
;
;               library("times")
;               x = read("dmus58.dat")
;               x = x[1:1000]
;               m = #(10,15,20)
;               q = neweywest(x,m)
;               q
; ----------------------------------------------------------------------
;   Result
;               Contents of q
;
;              [1,]  0.0040569 
;              [2,]  0.0058755 
;              [3,]  0.0076776 
; ----------------------------------------------------------------------
;   Reference
;      Newey, W. and K.D. West (1987): A Simple, Positive, Heteroskedasticity and
;       Autocorrelation Consistent Covariance Matrix. Econometrica, 55, 703-705.
; ----------------------------------------------------------------------
;   Keywords
;      long memory, tests
; ----------------------------------------------------------------------
;   Author        Gilles Teyssiere, 980425. Revised 990120
; ----------------------------------------------------------------------
  ;;    
  opt = 0 ; tests the presence of the optional matrix of truncation lags parameters
  if (exist(m)==1)
    nbtrunclag = rows(m)
    m = rint(m)  
  else
    nbtrunclag = 4
    m = #(5,10,25,50) 
  endif
  ;;
  hacv = matrix(nbtrunclag)
  n = rows(y)
  sig2 = var(y)*(n-1)/n
  gcv = acf(y)*var(y) 
	i = 1
	while (i<= nbtrunclag)
		q = m[i]
  	j = 1
  	sum1 = 0
  	while (j <= q)
    	sum1 = sum1 + (1-j/(1+q))*gcv[j+1]
    	j = j+1
  	endo
  	hacv[i] = sig2+2*sum1
		i = i+1
  endo
	sigma2= hacv
endp
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; end of macro neweywest
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
