proc(y) = nmomnorm(t,n)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rICfil, calibrIC, ICerzsep, ICerz
; -----------------------------------------------------------------
;   Macro        nmomnorm
; -----------------------------------------------------------------
;   Description  Auxiliary routine for ricfil:
;                calculates the n-th moment
;                of a standard normal variate
;                truncated at t, i.e. E [X^n (X<t)]
;                for X~N(0,1)
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rIC
; -----------------------------------------------------------------
;   Usage          y=nmomnorm(t,n)
;   Input
;     Parameter   t  
;     Definition     numeric; clipping point
;     Parameter   n 
;     Definition      integer; order of the moment
; Output                                                           
;     Parameter   y
;     Definition      numeric;n-th clipped moment
; -----------------------------------------------------------------
; Notes
;      Not to be used outside of ricfil!
; 
;      Is called by 
;                  betrnormE betrnormF betrnormV.
; -----------------------------------------------------------------
;   Example   to be looked up in rICfil
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------
  
if (n>1) 
    y2=nmomnorm (t,n-2)
    y1=pdfn(t)
    y=(n-1).*y2-t^(n-1).*y1   
endif
if (n==1)
    y=-pdfn(t)
endif
if (n==0)
    y=cdfn(t)
endif 

endp
