proc(omega)=omegagen(coeff,gam,phi,sigma,h);
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  omerrgen
; ----------------------------------------------------------------------
;   Macro	  omegagen
; ----------------------------------------------------------------------
;   Description   calculates the correction term for MSE matrix of 
;                 h-step forecasts in VAR models
; ----------------------------------------------------------------------
;   Usage         omega = omegagen(coeff,gam,phi,sigma,h)
;   Input 
;     Parameter   coeff 
;     Definition     matrix, the coefficients 
;     Parameter   gam 
;     Definition     matrix 
;     Parameter   phi 
;     Definition     matrix 
;     Parameter   sigma 
;     Definition     vector, standard error
;     Parameter   h 
;     Definition     integer, forecast horizon
;   Output
;     Parameter   omega
;     Definition     matrix 
; ----------------------------------------------------------------------
;   Author        Hafner, Sperlich 971120
; ---------------------------------------------------------------------- 
if (coeff==0)
   omega=0;
else;
   g2=inv(gam);
   k1=cols(coeff);
   k2=cols(phi);
   i1=1;
   omega=zeros(1,k2);
   while (i1<=h)
      var1=0;
      i2=0;
      while (i2<=(i1-1))
         i3=0;
         while (i3<=(i1-1))
            c=spur(power(coeff,i1-i2-1)'*g2*power(coeff,i1-1-i3)*gam)
            c=c*phi[i2*k2+1:(i2+1)*k2,]*sigma*phi[i3*k2+1:(i3+1)*k2,]';
            var1=var1+c
            i3=i3+1;
         endo;
         i2=i2+1;
      endo;
      omega=omega | var1;
      i1=i1+1;
   endo;
   omega=omega[2:rows(omega),];
endif;
endp;
