proc()=optstart()
; -----------------------------------------------------------------
; Library  	  finance
; -----------------------------------------------------------------
;  See_also       european, american, bs1, volatility, 
;                 mcmillan, asset, bitree
; -----------------------------------------------------------------
;   Macro         optstart
; -----------------------------------------------------------------
;   Description   this is the starting program to calculate
;                 option prices or implied volatilities
; -----------------------------------------------------------------
;   Usage         optstart()
;   Input         
;   Output        
; -----------------------------------------------------------------
;   Example   library("finance")
;             optstart()
; -----------------------------------------------------------------
;   Result    either option price of american or european option
;             or     implied volatility
;             using the Black and Scholes formula for the european
;             or the Mc Millan formula for the american option
;             or it is using binomial trees
; -----------------------------------------------------------------
;   Author    Feldmann, Sperlich  970217 
; -----------------------------------------------------------------
 sel1head = "Option Pricing: Select the method"
 sel1item = "Black/Scholes & MC Millan"|"Binomial Tree"
 sel1 = matrix(2)*0
 sel1 = selectitem (sel1head, sel1item)
    sel = matrix(3)*0
    selhead = "Option Pricing: Select the style of your option"
    selitem = "European"|"American"|"END"
 if (sel1[2])
  do  
    sel = selectitem (selhead, selitem)
    if (sel[1])
      asset(0)
    endif 
    if (sel[2])
      asset(1)
    endif
    if (sel[3])
      sel[3]=0
    endif
  until(sum(sel).=0) 
 else
  do  
    sel = selectitem (selhead, selitem)
    if (sel[1])
      european()
    endif 
    if (sel[2])
      american()
    endif
    if (sel[3])
      sel[3]=0
    endif
  until(sum(sel).=0) 
 endif
endp
