proc(summ)=panstats(z,T) 
; ---------------------------------------------------------------------
; Library     metrics 
; ----------------------------------------------------------------------
; See_also    summarize
; ---------------------------------------------------------------------
; Macro       panstats
; ---------------------------------------------------------------------
; Description Computes summary statistics of the variables
; ---------------------------------------------------------------------
; Usage       output=panstats(z,{T})
; Input       
; Parameter   z  
; Definition     NT x {2+} + k  Matrix, dataset
; Parameter   T     
; Definition     scalar, number of time periods for a BALANCED Dataset
;                IMPORTANT: No column for the Index of Individuals!
;                (Optional, only for a Dataset with the same T
;                for all Individuals = BALANCED PANEL)  
; Output      
; Parameter   output  
; Definition        string, output table with summary statistics
; ---------------------------------------------------------------------
; Example     	library("metrics")
;		z=read("earnings")
;             	panstats(z)
; ---------------------------------------------------------------------
; Result      
;	[ 1,] " "
;	[ 2,] " N*T:       500,  N:     100,  Min T(i):   5,  Max T(i):   5"
;	[ 3,] "------------------------------------------------------------"
;	[ 4,] "     Minimum     Maximum      Mean    Within Var.% Std.Error"
;	[ 5,] "------------------------------------------------------------"
;	[ 6,] "        1350     1.3e+04        3938       17.87        1513"
;	[ 7,] "           5          45       24.25        2.27       9.351"
;	[ 8,] "           9          13        9.94      0.2764       1.319"
;	[ 9,] "           1           2        1.34           0      0.4742"
;	[10,] " "
; ---------------------------------------------------------------------
; Keywords    panel 
; ---------------------------------------------------------------------
; Reference   
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Joerg Breitung 990316
; ---------------------------------------------------------------------
  NT=rows(z)
  k=cols(z)  

  if (exist(T)) 
    if (T>0)
      N=NT/T
      ind=(1:N)  
      ind=kron(ind,matrix(T,1))
      z=ind~z
      k=k+1
    endif
  else
    z=z[,1]~z[,3:k]
    k=k-1 
	endif	
 
  x=z[,2:k]

  error(rows(dim(x))>2,"first argument must be vector or matrix")
  error(exist(x)!=1,"first argument must be numeric")

  nmiss=0
  n=rows(x)
  if (max(prod(isNumber(x)==1,2))==1)
    x=paf(x,prod(isNumber(x)==1,2))
    nmiss=n-rows(x)
  else
    nmiss=n
  endif

  
  mz=mean(x)  

  pos=1
  within=0
  total=0
  N=0
  Tmin=NT
  Tmax=0
  while(pos < NT-1) 
    ind=z[pos,1]
    zi=z[pos,2:k]
    pos=pos+1
    while (z[pos,1]==ind)
      zi=zi|z[pos,2:k]
      pos=pos+1
    endo
    Ti=rows(zi)
    Tmin=min(Ti|Tmin)
    Tmax=max(Ti|Tmax) 
    mzi=mean(zi)
    within=within+sum(zi^2)-Ti*mzi^2
    total=total+sum(zi^2)-Ti*mz^2
    N=N+1
  endo

  within=100.*within./total 

  summ=min(x)'~max(x)'~mean(x)'~within'~sqrt(var(x))'

    j=0
    while (j<cols(summ))
      j=j+1
      if (j==1)
        summtxt=string(" %11.4g",summ[,1])
      else
        summtxt=summtxt+string(" %11.4g",summ[,j])
      endif
    endo 

  if (nmiss<n)
    x=(0*matrix(rows(x),cols(x))).*(x==0)+x.*(x!=0)
    xvars=string("Variable %2.0f",1:cols(x))
    xvars=string("Variable %2.0f",1:cols(x))
    sample=string(" N*T:%10.0f,",NT)
    sample=sample+string("  N:%8.0f,",N)
    sample=sample+string("  Min T(i):%4.0f,",Tmin)
    sample=sample+string("  Max T(i):%4.0f",Tmax)
    line="------------------------------------------------------------"

    summ=     ("     Minimum"|"------------") 
    summ=summ+("     Maximum"|"------------")
    summ=summ+("      Mean  "|"------------")
    summ=summ+("  Within Var.%"|"------------")
    summ=summ+(" Std.Error"|"------------")
    summ=" "|sample|line|summ|summtxt

    summ=summ|" "
    if (nmiss>0)
      summ=summ|string(" %1.0f",nmiss)+" observation(s) containing {-Inf,Inf,NaN} excluded."|" "
    endif
  else
    summ=" "|" All observations contain {-Inf,Inf,NaN}."|" "
  endif


endp


