proc (pc) = pca(x)
; -----------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------
; See_also     draftman factor
; -----------------------------------------------------------------
; Macro        pca
; -----------------------------------------------------------------
; Description  PCA performs a Principal Component Analysis for x.
;              It is possible to choose interactively between   
;              different criteria for the PCA's and confidence 
;              intervals.                       
; -----------------------------------------------------------------
; Usage        pc = pca (x)
; Input
;   Parameter  x  
;   Definition n x p matrix
; Output
;   Parameter  pc.y  
;   Definition n x p matrix  principal components
;   Parameter  pc.gamma  
;   Definition p x p matrix  of eigenvectors
;   Parameter  pc.lambda  
;   Definition p x 1 matrix  of eigenvalues
; -----------------------------------------------------------------
; Example      ; loads the library stats
;              library("stats")   
;              ; loads the library graphic
;              library("graphic")                                       
;              ; reads the swiss banknote data
;              x  = read("bank2")             
;              ; shows the principal components of x                          
;              pc = pca(x)                             
; -----------------------------------------------------------------
; Result    The graphic is divided into two displays. One shows a 
;           a scatterplot matrix of X. The second shows at the top
;           a parallel coordinate plot of gamma (matrix of the 
;           eigenvectors) and at the bottom the scree plot. 
;           Interactively you can choose between different criteria
;           for the number important principal components and 
;           confidence intervals for the eigenvalues (assumed that
;           they are really all different).
; -----------------------------------------------------------------
; Author    Katharina Kroel, Kerstin Zanter, 961202, 
;           Sigbert Klinke 970820  
; -----------------------------------------------------------------
  error(cols(x).<3 , "pca: col(x)<3")
  m = mean(x)
  n = cols(x)
  c = cov(x-m)
  {lambda, gamma}=eigsm(c)  
  c = lambda~trans(gamma)          
  c = sort(c, -1)                 
  lambda = c[,1]
  gamma  = trans(c[,2:cols(c)])
  y  = (x-m)*gamma                 
  draftman(y,0,3)
  bp = grpcp(gamma) 
  pc = list(y, gamma, lambda)
;
  db = createdisplay(2, 1)
  show    (db,1,1,bp)
  setgopt (db,1,1,"title","Parallel Coordinate Plot")
  setgopt (db,1,1,"xlabel","Eigenvectos of cov(X)","ylabel","Variables X_i")
  show    (db,2,1,(1:cols(x))~lambda)
  setgopt (db,2,1,"title","Scree Plot")
  setgopt (db,2,1,"xlabel"," Index of eigenvalues","ylabel","Eigenvalues")
; 
  selhead = "PCA"
  selitem = "Choosing important PCs"|"Confidence intervals for ev's"
  end = 0
  l   = 90
  z   = 90
  i   = sum(lambda.>1)
  logl= log(lambda)
  varl= 2/(n-1)
  zb  = qfn(0.95)
  gro = exp(logl+zb*(sqrt(varl)))
  gru = exp(logl-zb*(sqrt(varl)))  	
  gr  = grxline(i+0.5,0|max(gro))
  ug  = (1:cols(x))~gru
  og  = (1:cols(x))~gro
;
  do
    sel = selectitem (selhead, selitem)
    end = sum (sel).=0
    if (sel[1])
      selhead1="Criteria"
      selitem1="Variance"|"Kaiser"|"Ellbow"
;	
      sel1 = selectitem (selhead1, selitem1)
      if(sel1[1])
        do
          l=readvalue("Percentage of variance explained",l)
  	until((l<100)&& (l>0))  
        a  = cumsum(lambda)./sum(lambda)
        i  = sum(a.<(l/100))+1
        s  = string("The number of eigenvalues is %1.",i) 
        gr = grxline(i+0.5, 0|max(gro))
        setmaskp (og, 4,12,8)
        setmaskp (ug, 4,12,8)
        show (db,2,1,(1:cols(x))~lambda,gr,ug,og)
        titl = string(" Scree Plot with confidence interval (%2.0f %%)",z)
        setgopt (db,2,1,"title",titl)          
        setgopt (db,2,1,"xlabel","Index of eigenvalues","ylabel","Eigenvalues")
      endif 
      if (sel1[2])
        i  = sum(lambda .>1)
        gr = grxline(i+0.5, 0|max(gro))
        setmaskp (og, 4,12,8)
        setmaskp (ug, 4,12,8)
        show (db,2,1,(1:cols(x))~lambda,gr,ug,og)
        titl = string("  Scree Plot with confidence interval (%2.0f %%)",z)
        setgopt (db,2,1,"title",titl)          
        setgopt (db,2,1,"xlabel","Index of Eigenvalues","ylabel","Eigenvalues")
      endif 
      if (sel1[3])
        dif  = lambda[1:(cols(lambda')-1)]- lambda[2:cols(lambda')]	
	dif2 = dif[1:(cols(dif')-1)]- dif[2:cols(dif')] 
        i    = 1
        if (dif2.<=0)
           i=i+1
        endif
        gr   = grxline(i+0.5, 0|max(gro))
        setmaskp (og, 4,12,8)
        setmaskp (ug, 4,12,8)
        show (db,2,1,(1:cols(x))~lambda,gr,ug,og)                
        titl = string("  Scree Plot with confidence interval (%2.0f %%)",z)
        setgopt (db,2,1,"title",titl)          
        setgopt (db,2,1,"xlabel","Index of Eigenvalues","ylabel","Eigenvalues")
      endif
    endif 
;
    if (sel[2])
      gr = grxline(i+0.5, 0|max(gro))
      do
        z = readvalue(" Niveau of confidence interval",z)
      until ((z<100) && (z>0)) 
      logl   = log(lambda)
      varl   = 2/(n-1)
      zb     = qfn(z/200+0.5)
      gro    = exp(logl+zb*(sqrt(varl)))
      gru    = exp(logl-zb*(sqrt(varl))) 
      color  = 3*(1:cols(lambda))
      layout = 4*matrix(1:cols(lambda))
      og     = (1:cols(x))~gro
      ug     = (1:cols(x))~gru
      setmaskp (og, 4,12,8)
      setmaskp (ug, 4,12,8)
      show     (db,2,1,(1:cols(x))~lambda,ug,og,(1:cols(x))~lambda,gr)     
      titl = string("  Scree Plot with confidence interval (%2.0f %%)",z)
      setgopt (db,2,1,"title",titl)          
      titl   = string(" Scree Plot mit Konfidenzintervallen  %2.0f Prozent",z)
    endif
  until (end)
endp   
