proc (r) = pickandsgpdiag (x, k)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      pickandsgp
; -----------------------------------------------------------------
;   Macro         pickandsgpdiag
; -----------------------------------------------------------------
;   Description   Vector of Pickands estimator for GP model.
; -----------------------------------------------------------------
;   Usage         r = pickandsgpdiag (x, k)
;   Input
;     Parameter   x
;     Definition      vector
;     Parameter   k
;     Definition      vector, number of exceedances
;   Output
;     Parameter   r
;     Definition      vector with shape parameters
; -----------------------------------------------------------------
;   Example   library("finance")
;	      x=randx("gp",100,1)
;             r=pickandsgpdiag(x,4:100)
; -----------------------------------------------------------------
;   Result    Vector with estimated shape parameter for all number of
;             extremes provided in k
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  n = rows (x)
  error (n < 4, "Data set must have at least 4 elements")
  x = sort (x)
  i = 1
  l = rows (k)
  while (i <= l)
    error (k [i] < 4 || k [i] > n, "Invalid number of extremes (4 <= k <= n)")  
    m = floor (k [i] / 4)
    gamma = log ((x [n - m + 1] - x [n - 2*m + 1]) / (x [n - 2*m + 1] - x [n - 4*m + 1])) / log (2)
    if (i == 1)
      r = gamma
    else
      r = r | gamma
    endif
    i = i + 1
  endo
endp
