proc(hbeta,hg)=plmp(x,t,y,m,mn)
; -----------------------------------------------------------------
;    Library  plm
; -----------------------------------------------------------------
;    See_also plmk, plmlorg
; -----------------------------------------------------------------
;    Macro	plmp
; -----------------------------------------------------------------
;    Description   plmp estimates the parametric part in partially 
;		   linear models by using piecewise polynomial to 
;		   approximate the nonparametric part
; -----------------------------------------------------------------
;    Usage    res = plmp(x,t,y,m,mn)
;    Input
;      Parameter  x
;      Definition   n x p matrix, the design
;      Parameter  t
;      Definition   n  x 1 matrix, the design in [0, 1]
;      Parameter  y
;      Definition   n x 1 matrix, the response
;      Parameter  m
;      Definition   scalar, degree of piecewise polynomial
;      Parameter  mn
;      Definition   scalar, the numbers of intervals divided [0, 1] with
;		    length 1/mn.
;    Output
;      Parameter  res.hbeta
;      Definition   p x 1 matrix, the estimate of the parameter
;      Parameter  res.hg
;      Definition   n x 1 matrix, estimate of nonparameter function
; -----------------------------------------------------------------
;  Example library("plm")
;	   n = 100
;	   sig=0*matrix(3,3)
;	   sig[,1]=#(0.81,0.1,0.2)
;	   sig[,2]=#(0.1,2.25,0.1)
;	   sig[,3]=#(0.2,0.1,1)
;	   x =normal(n,3)*sig
;	   t =sort(uniform(n))
;          beta0=#(1.2, 1.3, 1.4)
;	   y =x*beta0+t^3+0.01*normal(n)
;	   m =2
;	   mn=5
;	   res=plmp(x,t,y,m,mn)
;          ddp=createdisplay(1,1)
;          datah1=t~t^3
;          datah2=t~res.hg
;          part=grid(1,1,rows(t))'
;          setmaskp(datah1,1,0,1)
;          setmaskp(datah2,4,0,3)
;          setmaskl(datah1,part,1,1,1)
;          setmaskl(datah2,part,4,1,3)
;          show(ddp,1,1,datah1,datah2)
;          setgopt(ddp,1,1,"xlabel","T","title","Simulation comparison","ylabel","g(T) and its estimate values")
; -----------------------------------------------------------------
;    Result   The parameter estimates, see Hung Chen "Convergence
;	Rates for Parametric Components in A Partly Liner Model",
;	Ann. of Statist. (1988) 16, 136-146.
; -----------------------------------------------------------------
;   Author    Hua Liang, 98
; -----------------------------------------------------------------
n=rows(x)
Z=0*matrix(n,(m+1)*mn)
 j=1
 while(j<(m+1)*mn)
   fl=j/(m+1)
   pl=floor(fl)
   if(fl-pl==0)
     q=fl
     r=m
   else
     q=pl+1
     r=j-(q-1)*(mn+1)-1
   endif
   Z[,j]=(((q-1)/mn<t).*(t<=q/mn)).*(t^r)
   j=j+1
endo
S=0.001*diag(matrix((m+1)*mn))
P=Z*inv(Z'*Z+S)*Z'
I=diag(matrix(n))
hbeta=inv(x'*(I-P)*x)*x'*(I-P)*y
hg=P*(y-x*hbeta)
endp
