proc () = plot (x1, x2, x3, x4, x5)
; -----------------------------------------------------------------
; Library        plot
; -----------------------------------------------------------------
;  See_also      createdisplay show line
; -----------------------------------------------------------------
;   Macro        plot
; -----------------------------------------------------------------
;   Description  Convenient function for plotting results. Creates
;		 a global variable (plotdisplay) that contains a plot
;                with at most five dataparts.
; -----------------------------------------------------------------
;   Usage        plot (x1, {x2, x3, x4, x5})
;   Input
;     Parameter  x1
;     Definition matrix containing x and y values for plot
;     Parameter  x2 - x5
;     Definition optional dataparts for the plot
;   Output
; -----------------------------------------------------------------
;   Example   library("plot")
;             plot (1:10~(1:10)^2)
; -----------------------------------------------------------------
;   Note
;	plot creates the local object "plotdisplay"
; -----------------------------------------------------------------
;   Result
;	plot is shown in the display plotdisplay
; -----------------------------------------------------------------
; Keywords    high level graphics
; -----------------------------------------------------------------------
;   Author    TTK, 961205
; -----------------------------------------------------------------

//  if (existglobal ("plotdisplay") != 4)
    plotdisplay = createdisplay (1,1)
//  else
//    plotdisplay = getglobal ("plotdisplay")
//  endif

  switch
    case (exist (x5))
      show (plotdisplay, 1, 1, x1, x2, x3, x4, x5)
      break
    case (exist (x4))
      show (plotdisplay, 1, 1, x1, x2, x3, x4)
      break
    case (exist (x3))
      show (plotdisplay, 1, 1, x1, x2, x3)
      break
    case (exist (x2))
      show (plotdisplay, 1, 1, x1, x2)
      break
    case (exist (x1))
      show (plotdisplay, 1, 1, x1)
      break
  endsw

endp