proc()=plotboxgrouped(ug,og,n,col)
; -----------------------------------------------------------------------
; Library      plot
; -----------------------------------------------------------------------
; See_also     grboxgrouped
; -----------------------------------------------------------------------
; Macro        plotboxgrouped
; -----------------------------------------------------------------------
; Description  Generates a boxplots for grouped data with mean line (dotted)
;              and median line (solid).
; -----------------------------------------------------------------------
; Usage        plotboxgrouped (ug, og, n {, col})
; Input
;   Parameter  ug
;   Definition p x 1      sorted vector of lower borders of group
;   Parameter  og
;   Definition p x 1      sorted vector of upper borders of group
;   Parameter  n
;   Definition p x 1      vector of absolute or relative frequencies of group
;   Parameter  col
;   Definition color
; Output
; -----------------------------------------------------------------------
; Note				 It is not checked if the borders are in sorted order or
;              if relative frequencies add up to one.
; -----------------------------------------------------------------------
; Example      library ("plot")
;              // structure of age of women in west germany 31.12.95
;              ug1 = #(0, 15, 40, 65)
;              og1 = #(15, 40, 65, 80) 
;              t1  = #(5326, 11911, 10725, 6735)
;              // structure of age of women in east germany 31.12.95
;              ug2 = #(0, 15, 40, 65)
;              og2 = #(15, 40, 65, 78) 
;              t2  = #(1119, 2384, 2380, 1412)
;              // generate plots
;              plotboxgrouped (ug1~ug2, og1~og2, t1~t2)
; -----------------------------------------------------------------------
; Result       shows a boxplot for grouped data
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html  Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, boxplot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 981123
; -----------------------------------------------------------------------
  m   = rows(n)
  p   = max(cols(n)|cols(ug)|cols(og))
  error ((cols(n)>1) && (cols(n)<>p), "plotboxgrouped: cols(n) do not match")
  error ((cols(og)>1) && (cols(og)<>p), "plotboxgrouped: cols(og) do not match")
  error ((cols(ug)>1) && (cols(ug)<>p), "plotboxgrouped: cols(ug) do not match")
  error (m<>rows(ug), "plotboxgrouped: rows(n)<>rows(ug)");
  error (m<>rows(og), "plotboxgrouped: rows(n)<>rows(og)");
  wog = og.*matrix(m,p)
  wug = ug.*matrix(m,p)
  wn  = n.*matrix(m,p)
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black*matrix(p)
  else
    error ((rows(col)>1) && (rows(col)<>p), "plotboxgrouped: rows(col) do not match");  
  endif
  col = col.*matrix(p)
  iv = #(min(min(ug),2), max(max(wog),2))~#(0,1)
  setmaskp(iv, 0, 0, 0)
  d  = createdisplay(p,1)
  i  = 0
  while (i<p)
    i  = i+1
    gr  = grboxgrouped(wug[,i], wog[,i], wn[,i], col[i,]) 
    txt = gr.values~(0.9|0.8|0.7|0.8|0.9|0.1)
    setmaskp (txt, 0, 0, 0)
    setmaskt (txt, string("%f", gr.values), col[i,], 3|9|0|3|9|0, 12)
    show(d, i, 1, gr, iv, txt)
    setgopt(d, i, 1, "xoffset", 0|0)
  endo
endp  
