proc()=plotcarttree(tr,string)
; -----------------------------------------------------------------------
; Library       xclust
; -----------------------------------------------------------------------
; See_also      cartsplit, dispcarttree, grcarttree, plotcart2
; -----------------------------------------------------------------------
; Macro         plotcarttree
; -----------------------------------------------------------------------
; Description   Plots the regression tree of CART.
; -----------------------------------------------------------------------
; Usage         plotcarttree (cs {, stri})
; Input        
;   Parameter   cs
;   Definition  list of vectors: data structure which represents a binary tree
;               and is produced by cartsplit procedure, contains vectors ..
;               cs.val, cs.vec, cs.mean, cs.ssr, cs.nelem.
;               See cartsplit for the description of cs.
;   Parameter   stri
;   Definition  string: optional argument,
;               either missing, "nelem", "ssr" or "mean".
; -----------------------------------------------------------------------
; Notes 
;               The content of the nodes in the picture of the tree 
;               is determined by the parameter stri.
;               If this parameter is not given, in the nonterminal 
;               nodes there
;               are given the splitting rule 
;               (for example x1<=1.34), and in the leaf nodes there are
;               given the values of the regression function, that is,
;               the mean of the observations in that node.
;               If stri = "nelem", 
;               the number of observations in the nodes is plotted,
;               if stri = "ssr",
;               the sum of squared residuals in the nodes is plotted,
;               and if stri = "mean",
;               the mean of observations in the nodes is plotted. 
; -----------------------------------------------------------------------
; Example      ; loads the library xclust
;              library ("xclust")
;              ; generate an artifcal dataset
;              x1=#(0,0,0,0,1,1,1,1,1,2)
;              x2=#(0,0,0,0,0,0,0,1,1,1)
;              x=x1~x2
;              y=#(0,0,0,0,100,100,100,120,120,120)
;              ; run CART on our data
;              cs=cartsplit(x,y,#(0,1))
;              ; plot CART tree
;              plotcarttree(cs)
; -----------------------------------------------------------------------
; Result       shows the tree with the splitting rules
; ---------------------------------------------------------------------
; Keywords     CART
; ---------------------------------------------------------------------
; Reference    Breiman, L., Friedman, J., Olshen, R., and Stone, C. J. (1984). 
;              Classification and Regression Trees. Chapman & Hall, New York
; ---------------------------------------------------------------------
; Link         ..\tutorials\cartstart.html CART Tutorial
; ---------------------------------------------------------------------
; Author       1999 Jussi Klemelae, 2000-04-15, Sigbert Klinke
; ---------------------------------------------------------------------
  if (exist("string").=0)
    string = "empty"
  endif
; show all data
  ctdisp = createdisplay(1,1)
  dispcarttree(ctdisp, 1, 1, tr, string)
endp
