proc ()=plotnan(data, xyname, option)
; ---------------------------------------------------------------------
; Library  plot   
; ---------------------------------------------------------------------
; See_also  plot plot2  
; ---------------------------------------------------------------------
; Macro       plotnan
; ---------------------------------------------------------------------
; Description Plots a data set in a scatterplot and includes the
;             missing values in the data. 
; ---------------------------------------------------------------------
; Usage       plotnan(data,xyname,option)
; Input       
; Parameter   data
; Definition  nx2 matrix
; Parameter   xyname
; Definition  2x1 textmatrix
; Parameter   option
; Definition  1x1 textmatrix
; Output      
; ---------------------------------------------------------------------
; Notes       Option specifies how the missing will be represented 
;             (default: grdash)
; ---------------------------------------------------------------------
; Keywords    high level graphics
; ---------------------------------------------------------------------
	if (cols(data)!=2)
		error(cols(data), "a data with two columns is wanted!")
	endif
	nan1=paf(data, (isNaN(data[,1]) &&(!isNaN(data[,2]))))
	nan2=paf(data, (!isNaN(data[,1]) &&(isNaN(data[,2]))))
        nonan=paf(data, (!isNaN(data[,1]) &&(!isNaN(data[,2]))))	
	setsize(700, 700)
	axeson()
	d=createdisplay(2, 2)
	setfractions(d, 4|1, 1|4)	
	minmax=min(data)|max(data)
	offset=(minmax[2]-minmax[1])/20
	minmax=minmax+((-offset)|offset)
	exist(xyname)
        if (exist(xyname))
            if (cols(xyname)!=2)
		warning(0, "a bad second parameter!")
		xname="x"
		yname="y"
            else
		xname=xyname[,1]
		yname=xyname[,2]
            endif
	else
	    xname="x"
	    yname="y"
	endif	
	
	xy=nonan
	setmaskp(xy, 0, 8, 5)
	show(d, 1, 2, xy)
	setgopt(d, 1, 2, "xlim", minmax[,1], "ylim", minmax[,2])
	setgopt(d, 1, 2, "title", "Data without missing values")
	setgopt(d, 1, 2, "ylabel", yname)
	setgopt(d, 1, 2, "xlabel", xname)
	if (!exist(option))
		option="grdash"
	endif
	option
	switch
		case (option=="grdash")
		xy22=nan2[,1]~matrix(rows(nan2[,1]))
		xy11=nan1[,2]~matrix(rows(nan1[,2]))
		setmaskp(xy11, 0, 8, 5)	
		setmaskp(xy22, 0, 8, 5)	
		break
		
		case (option=="grdot")
		xy22=grdot(nan2[,1])
		xy11=grdot(nan1[,2])
		break
		
		case (option=="grdotd")
		xy22=grdotd(nan2[,1])
		xy11=grdotd(nan1[,2])
		break
		case (option=="grdotdl")
		xy22=grdotdl(nan2[,1])
		xy11=grdotdl(nan1[,2])
	break
		case (option=="grhist")
		xy22=grhist(nan2[,1])
		xy11=grhist(nan1[,2])
	break
		case (option=="grbar")
		xy22=grbar(nan2[,1])
		xy11=grbar(nan1[,2])
	break
		case (option=="grbox")
		xy22=grbox(nan2[,1])
		xy11=grbox(nan1[,2])
		break
		default
		xy22=nan2[,1]~matrix(rows(nan2[,1]))
		xy11=matrix(rows(nan1[,2]))~nan1[,2]
	break	
	endsw
	
	xy11=grrot(xy11, 1)
	show(d, 1, 1, xy11)
	setgopt(d, 1, 1, "ylim", minmax[,2], "xoffset", 40|0, "xmajor", 10)
	setgopt(d, 1, 1, "ylabel", yname+" missing X")
	setgopt(d, 1, 1, "xlabel", option, "yoffset", 10|10)
	setgopt(d, 1, 1, "xmajor", 20, "xorigin", -0.5)
	show(d, 2, 2, xy22)
	setgopt(d, 2, 2, "xlim", minmax[,1], "yoffset", 0|40)
	setgopt(d, 2, 2, "xlabel", xname+" missing Y")
	setgopt(d, 2, 2, "ymajor", 20, "yorigin", -0.5)
	setgopt(d, 2, 2, "ylabel", option, "xoffset", 10|10)
 	setgopt(d, 1, 2, "yoffset", 10|10, "xoffset", 10|10)  
 	setgopt(d, 1, 2, "ylim", minmax[,2], "xlim", minmax[,1])  
	s1=string("NaN X: %.0f", rows(nan1))
	s2=string("NaN Y: %.0f", rows(nan2))
	nanxy=rows(data)-rows(nonan)-rows(nan1)-rows(nan2)
	s3="NaN X"
	s4=string("and Y: %.0f", nanxy)
	show(d, 2, 1, s1|"--------"|s2|"--------"|s3|s4) 
	s1|s2|s3
endp