proc(y)=prunetot(tree,lnum)
;calls 
;endpoint.xpl, gform.xpl, init.xpl, leafnum.xpl, 
;maketr.xpl, smsr.xpl, final.xpl, suitind.xpl,
;omaind.xpl.
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     cartsplit, cartcv, cartsplitopt, leafnum, maketr, pred, 
;              prederr, prune, prunecv, pruneseq, ssr, kuva
; -----------------------------------------------------------------------
; Macro        prunetot
; -----------------------------------------------------------------------
; Description   Prunes a smaller regression tree from a tree which has been 
;               created by the cartsplit procedure. 
; -----------------------------------------------------------------------
; Usage         subcs = prunetot (cs, lnum)
; Input        
;   Parameter  cs
;   Definition  list of vectors: data structure which represents a binary tree
;            and is produced by cartsplit procedure, contains vectors 
;            cs.val, cs.vec, cs.mean, cs.ssr, cs.nelem.
;            See cartsplit for the description of cs.
;   Parameter  lnum
;   Definition  integer >= 1: the tree subcs will have lnum leaves.
;            The pruning method produces a sequence of subtrees from
;            the original tree, the program prunetot selects from that
;            sequence a tree which has a number of leaves greater or equal
;            to lnum and then removes subtrees by minimizing sum of rquared
;            residuals until a subtree with number of leaves exactly to
;            lnum is formed.  
; Output       
;   Parameter  subcs
;   Definition similar kind of object than cs, see cartsplit for the
;            description of subcs. Number of leaves of subcs is lnum.
; -----------------------------------------------------------------------
; Notes    Pruning is described by Breiman, Friedman, Olshen, and Stone,
;          Classification and Regression Trees, 1984, Wadsworth,
;          pages 63, 284. 
; -----------------------------------------------------------------------
; Example      ; loads the library xclust
;              library ("xclust")
; ;let us generate a tree by cartsplit procedure
; x1=#(0,0,0,0,1,1,1,1,1,2)
; x2=#(0,0,0,0,0,0,0,1,1,1)
; x=x1~x2
; y=#(0,0,0,0,100,100,100,120,120,120)
; cs=cartsplit(x,y,#(0,1))
; cs
; ; let us choose a subtree with two leaves
; subcs=prune(cs,2)
; subcs
; -----------------------------------------------------------------------
; Result  
; Content of object cs.val.split0
; [1,] 0 
; [2,] 1,2 
; Content of object cs.val.split1
; [1,] NaN 
; Content of object cs.val.split2
; [1,] 0 
; Content of object cs.val.split3
; [1,] NaN 
; Content of object cs.val.split4
; [1,] NaN 
; Content of object cs.vec
; [1,] 1.000000 
; [2,] NaN 
; [3,] 2.000000 
; [4,] NaN 
; [5,] NaN 
; Content of object cs.mean
; [1,] 66.000000 
; [2,] 0.000000 
; [3,] 110.000000 
; [4,] 100.000000 
; [5,] 120.000000 
; Content of object cs.var
; [1,] 29640.000000 
; [2,] 0.000000 
; [3,] 600.000000 
; [4,] 0.000000 
; [5,] 0.000000 
; Content of object cs.nelem
; [1,] 10.000000 
; [2,] 4.000000 
; [3,] 6.000000 
; [4,] 3.000000 
; [5,] 3.000000 
; 
; Content of object subcs.val.split0
; [1,] 0 
; [2,] 1,2 
; Content of object subcs.val.split1
; [1,] NaN 
; Content of object subcs.val.split2
; [1,] NaN 
; Content of object subcs.vec
; [1,] 1.000000 
; [2,] NaN 
; [3,] NaN 
; Content of object subcs.mean
; [1,] 66.000000 
; [2,] 0.000000 
; [3,] 110.000000 
; Content of object subcs.var
; [1,] 29640.000000 
; [2,] 0.000000 
; [3,] 600.000000 
; Content of object subcs.nelem
; [1,] 10.000000 
; [2,] 4.000000 
; [3,] 6.000000      
; -----------------------------------------------------------------------
; Author       Jussi Klemel , 980323         
; -----------------------------------------------------------------------
if (leafnum(tree,1)==1) y=tree
else
tr=init(tree)
if (leafnum(tr,1)==1) y=tr
    else
    curlnum=leafnum(tr,1)
    subtr=tr
    while ((curlnum > 1) && (curlnum >= lnum))
     g=gform(tr)
     tmin=omaind(g)
     aputr=tr
     tr=subtr
     subtr=maketr(aputr,tmin)
     curlnum=leafnum(subtr,1)
    endo
    ;lnsub=leafnum(subtr,1)
    ;ln=leafnum(tr,1)
    ;ab1=abs(lnsub-lnum)
    ;ab2=abs(ln-lnum)
    ;if (ab1 < ab2) y=subtr
    ;else 
    tr=final(tr,lnum)
    y=tr
    ;endif
endif
endif
endp
