proc(z)=qp0(H,f,A,b)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     bfgs nelmin
; -----------------------------------------------------------------------
; Macro        qp0
; -----------------------------------------------------------------------
; Description  solves a quadratic optimization problem with linear 
;              inequality constraints  
; -----------------------------------------------------------------------
; Usage        z = qp0 (H,f,A,b)
; Input        
;   Parameter  H
;   Definition nxn matrix
;   Parameter  f
;   Definition nx1 matrix
;   Parameter  A
;   Definition kxn matrix
;   Parameter  b
;   Definition kx1 matrix
; Output       
;   Parameter  z
;   Definition nx1 matrix
; -----------------------------------------------------------------------
; Notes        z is the solution of 0.5 x'*H*x+f'x under the constraint
;              Ax <= b and x>=0. For b holds: b>=0. 
; -----------------------------------------------------------------------
; Example      library("math")
;              H=#(9,14,13,10)
;              H=H~#(14,23,21,19)
;              H=H~#(13,21,26,18)
;              H=H~#(10,19,18,25)
;              f=#(-140,-238,-234,-232)
;              A=trans(#(1,2,3,4)~#(3,1,4,2))
;              b=#(6,10)
;              qp0(H,f,A,b)
; -----------------------------------------------------------------------
; Result       Contents of z
;              [1,] 2.8
;              [2,] 1.6
;              [3,] 0
;              [4,] 0
; -----------------------------------------------------------------------
// check if matrices have the right size
  n = rows(H)
  k = rows(A)
  error(n<>cols(H), "qp0: rows(H)<>cols(H)")
  error(n<>rows(f), "qp0: rows(H)<>rows(f)")
  error(cols(f)<>1, "qp0: cols(f)<>1")
  error(n<>cols(A), "qp0: rows(H)<>cols(A)")
  error(k<>rows(b), "qp0: rows(A)<>rows(b)") 
  error(cols(b)<>1, "qp0: cols(b)<>1")
// build correct name
  if (getenv("os")=="windows")
    fn = "_qp0"
  else
    fn = "qp0"
  endif
// initialize result
  z = NaN.*matrix(n)
  t = NaN
// execute function
  ret = dlcall (getglobal("LibMathHandle"), fn, H, f, A, b, z, t, n|k)
endp