proc() = readshow (disp, w, u, x, y, dec, m, t, err, weidist, vmeth)
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     ann
; -----------------------------------------------------------------------
; Macro        readshow
; -----------------------------------------------------------------------
; Description  shows the visualization of a feedforward neural network
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, Janet Grassmann,  951231; 
;             Sigbert Klinke, 961121
; -----------------------------------------------------------------------
  mnu = "Training"|"Test"|"Edit Pic"|"Training-6"|"Test-6"
  v  = normal(rows(u), vmeth); ~m
  ve = v          
  xt  = paf (x, t.=0)
  xe  = paf (x, t.=1)          
  ybt = paf (y, t.=0)
  ybe = paf (y, t.=1)  
  wo  = w        
  yt  = nnfunc (w[,1:2]~w[,4], u, xt)
  ye  = nnfunc (w[,1:2]~w[,4], u, xe)          
  switch 
  case (err.=0)          
    errfun = "erfqua" 
    break        
  case (err.=1)          
    errfun = "erfkl" 
    break         
  endsw          
  s = (_errfun (ybt, yt, w[,4], dec))|(_errfun(ybe, ye, w[,4], dec))          
  d = w[,1:2]~_weidist(w[,4])            
  {ve, verr} = nnvisu(d, ve)            
  vb   = ve ; ~m~u$[,1]  
  setmaskp (vb, 0, m, 8)          
  ;mb = max(max(vb)./#(19, 13)).*trans(#(19, 13))            
  ;mb = (-mb|mb) ;~mask(2 1 black)            
  sb = s[2,1]            
  ;l = update(vb, 1, s2d1, noaxis, newproj)            
  ;l = update(mb, 2, s2d1, noaxis, newproj)            
  ;l = update(ybp, 1, s2d2, noaxis, line, dotted, newproj)            
  ;l = update(yep, 2, s2d2, noaxis, line, solid, newproj)            
  istr = "Test"           
  istr = istr|string ("Decay  : %f", dec)            
  istr = istr|string ("Verr   : %f", verr)            
  istr = istr|string ("N: %5.0f/%5.0f", rows(xt), rows(xe))            
  istr = istr|string ("E: %5.2f", sb)            
  ;writecon(27)            
  ;show(istr, text2) 
  sel = 1           
  while (sum(sel))            
    sel = selectitem ("readshow", mnu)  
    if (sel.=1)            
      d   = w[,1:2]~_weidist(w[,3])            
      {v, verr} = nnvisu(d, v)            
      vb   = v ;~u$[,1]    
      setmaskp (vb, 0, m, 8)      
      sb   = s[1,1]          
      ;istr = #("Training")               
    endif
    if (sel.=2)               
      d   = w[,1:2]~_weidist(w[,4])               
      {ve, verr} = nnvisu(d, ve)             
      vb   = ve; ~m~u$[,1]
      setmaskp (vb, 0, m, 8)               
      sb   = s[2,1]               
      ;istr = #("Test")               
    endif
    if (sel.=3)               
      ;vb%[,1] = m               
      ;istr = istr$[1,1]               
    endif
    if (sel.=4)               
      d   = w[,1:2]~_weidist(w[,3])            
      veo = 0    
      {v, verr} = nnvisu(d, v)            
      while (abs(veo-verr).>1.0e-5)  
        veo = verr  
        {v, verr} = nnvisu(d, v)  
      endo  
      vb   = v ;~m~u$[,1]
      setmaskp (vb, 0, m, 8)  
      sb   = s[1,1]  
      ;istr = #("Training")  
    endif
    if (sel.=5)  
      d   = w[,1:2]~_weidist(w[,4])  
      veo = 0  
      {ve, verr} = nnvisu(d, ve)  
      while (abs(veo-verr).>1.0e-5)  
        veo = verr  
        {ve, verr} = nnvisu(d, ve) 
      endo  
      vb   = ve ;~m~u$[,1]
      setmaskp (vb, 0, m, 8)  
      sb   = s[2,1]  
      ;istr = #("Test")  
    endif  
    ;mb = max(max(vb)./#(19 ,13)).*trans(#(19, 13))  
    ;mb = (-mb|mb) ;~mask(2, 1, black)  
    istr = istr|string ("Decay  : %f", dec)  
    istr = istr|string ("Verr   : %f", verr)               
    istr = istr|string ("N: %5.0f/%5.0f", rows(xt), rows(xe))               
    istr = istr|string ("E: %5.2f", sb)               
    ;writecon(27)               
    ;show(istr, text2) 
    show(disp, 2, 1, vb)               
    if (sel.=3)               
      ;link ("s2d1\data_1", u)               
      ;display(nndisp)               
    endif               
  endo               
endp               
