proc()=regressionplots(datap,x,b,y,Vin,yhat)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     committee doista neuronal regressionsave
; -----------------------------------------------------------------------
; Macro        regressionplots
; -----------------------------------------------------------------------
; Description  shows different plots after performing a regression 
;              analysis (linear regression or neuronal nets) and saving
;              the appropriate variables
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------  
  if(b<>0) ;linear regression performed?
    yhat=x*b
  endif
  u=y-yhat
  dfR=rows(x)-cols(x)-1
  use=sqrt(sum(u^2)/dfR)
  zresid=u./use
  dim(zresid) 
  selhead="Linear regression: Plots"
  ;all plots without NaNs regardless if NaNs exist or not"
  selitem="Scatterplot"|"Plots for standardized residuals"
  do
    sel=selectitem(selhead,selitem)
    if(sel[1])
      scatterp(datap)
    endif
    if(sel[2])
     selhead1="ZRESID"
     selitem1="Histogram"|"Boxplot"|"Normal Q-Q plot"|"Normal P-P plot"   
     do
       sel1=selectitem(selhead1,selitem1) 
     if(sel1[1])
         bp=grhist(zresid)
         d  = createdisplay (1,1) 
         show (d, 1, 1, bp) 
         setgopt(d,1,1,"title","Stand. Residuals","xlabel","ZRESID","ylabel","f(ZRESID)")
       endif
       if(sel1[2])
         bp = grbox (zresid)
         d  = createdisplay (1,1) 
         show (d, 1, 1, bp) 
         setgopt(d,1,1,"title","Stand. Residuals","xlabel","ZRESID")
       endif
       if(sel1[3])
         bp=grqqn (zresid)    
         d  = createdisplay (1,1) 
         show (d, 1, 1, bp)  
         setgopt(d,1,1,"title","Stand. Residuals Normal Q-Q plot","xlabel","observed value","ylabel","expected value")
        endif
       if(sel1[4])
         bp=grppn (zresid)    
         d  = createdisplay (1,1) 
         show (d, 1, 1, bp)  
         setgopt(d,1,1,"title","Stand. Residuals Normal P-P plot","xlabel","observed value","ylabel","expected value")
        endif
     until(sum(sel1).=0)   
   endif
 until(sum(sel).=0)
endp


