proc()=regressionstatistic(datain,datahx,y,b,bse,bstan,bpval,Vin,colhx,colhy,MSSRin)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     confidenceb confidenceycollinearity  covmatrix doista
;              descriptivelinreg durbinwatson  regressionselection 
; -----------------------------------------------------------------------
; Macro        regressionstatistic
; -----------------------------------------------------------------------
; Description  computes different statistics after performing a linear 
;              regression analysis
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------  
  selhead="Linear Regression: Statistics"
  selitem="95% Confidence intervals for b"|"95% Confidence intervals for Y"|"Covariance matrix of b"
  selitem=selitem|"Descriptive"|"Durbin Watson"|"Collinearity diagnostics"
  do
    sel=selectitem(selhead,selitem)
    if (sel[1])
      output=confidenceb(b,bse,datahx,Vin,colhx)
      output
    endif
    if (sel[2])
      output=confidencey(datahx,b,MSSRin,y,Vin)
      output
    endif
    if (sel[3])
      output=covmatrix(datahx,MSSRin,Vin,b,colhx)
      output
    endif  
   if (sel[4])
      descriptivelinreg(colhx,colhy,datahx,y,Vin)
    endif
    if (sel[5])
      {output,usum,usumname}=durbinwatson(datahx,y,b,Vin)
      output
      summarize(usum,usumname)
    endif  
    if (sel[6])
      output=collinearity(datahx,Vin)
      output
    endif 
  until(sum(sel).=0)
endp
