proc(sf)=sfvonbss(r,icovu,gam,di,ord,t)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     modelss 
; -----------------------------------------------------------------
;   Macro        sfvonbss
; -----------------------------------------------------------------
;   Description  standard errors of parameters for Subset VAR 
; -----------------------------------------------------------------
;   Usage        sf = sfvonbss(r,icovu,gam,di,ord,t)  
;   Input
;     Parameter   r  
;     Definition      matrix, restriction matrix
;     Parameter   icovu 
;     Definition      matrix
;     Parameter   gam  
;     Definition      matrix
;     Parameter   di 
;     Definition      integer, dimension of time series
;     Parameter   ord  
;     Definition      integer, order of VAR model
;     Parameter   t 
;     Definition      integer, sample size
;   Output
;     Parameter   sf
;     Definition      matrix of standard errors
; -----------------------------------------------------------------
;   Author    TP A2, CH 980409
; -----------------------------------------------------------------  
if (max(sum(r)')>0)
   sf=xdiag(r*inv(r'*(kron(icovu,gam'))*r)*r');
   sf=sqrt(reshape(sf/t,#(di*ord+1,di))');
else; 
   sf=zeros(di,ord*di+1);
endif;
endp;
