proc (s) = skewness (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      kurtosis
; -----------------------------------------------------------------
;  Keywords      moments, skewness
; -----------------------------------------------------------------
;   Macro        skewness
; -----------------------------------------------------------------
;   Description  Computes the skewness for a given vector.
; -----------------------------------------------------------------
;   Usage        s = skewness(x)
;   Input
;     Parameter  x  
;     Definition   vector
;   Output
;     Parameter  s
;     Definition   scalar
; -----------------------------------------------------------------
;   Example   library("xplore")
;             randomize (0)
;             x = normal (100)
;             skewness (x)
; -----------------------------------------------------------------
;   Result    
;	      Contents of s
;             [1,] -0.20169 
; -----------------------------------------------------------------
;   Author    TTK, 960207
; -----------------------------------------------------------------
  s  = mean ((x-mean(x))^3) ./ var(x)^1.5
endp           

