proc() = smoothertest()
; -----------------------------------------------------------------
;  Library       smoother
; -----------------------------------------------------------------
;  See_also      lpderest lpregauto lpderauto lprotint
;                lpregest denest denestp dengau gauder canker canbw
; -----------------------------------------------------------------
;  Macro         smoothertest
; -----------------------------------------------------------------
;  Description   smoothertest tests all the aforementioned macros
;                of the smoother.lib
; -----------------------------------------------------------------
;  Usage         smoothertest()
; -----------------------------------------------------------------
;  Author        Lijian Yang, 980108; Marlene Mueller 990419   
; -----------------------------------------------------------------
d1=createdisplay(3,3)
;
;testing the sker-dens *****************
x = normal(100)~uniform(100)                        
fh = denxestp (x)
setmaskp(fh,1,2,4)
show(d1,1,1,fh) 
;
;testing the sker-reg ******************
x = normal(200,2)
x=x~(sum(cos(x),2)+uniform (200))                       
mh = regxestp(x,2)
setmaskp(mh,1,2,4)
show(d1,2,1,mh) 
;
;testing the lpregest *****************
x=pi.*(uniform(200)-0.5)                               
x=x~(1-cos(x)+uniform(200))                                             
y=lpregest(x,0.3)                                         
setmaskp(x,0,3,4)
setmaskp(y,0,0,0)
setmaskl(y,(1:rows(y))',1,1,2)
show(d1,3,1,x,y)      
;
;testing the lpderest *****************
x = read("motcyc.dat")   
y = lpderest(x, 5)
setmaskp(x,0,3,4)
setmaskp(y,0,0,0)
setmaskl(y,(1:rows(y))',2,1,2)
show(d1,1,2,x,y)     
;
;testing the lpregauto ****************
hrot=lpregrot(x)
y=lpregest(x,hrot)
setmaskp(x,0,3,4)
setmaskp(y,0,0,0)
setmaskl(y,(1:rows(y))',1,1,2)
show(d1,2,2,x,y)   
;  
;testing the lpderauto ****************
hrot=lpderrot(x)
y1=lpderest(x,hrot)
setmaskp(y1,0,0,0)
setmaskl(y1,(1:rows(y1))',2,1,2)
show(d1,3,2,y,y1)   
;  
;testing the lprotint *****************
y = lprotint (1, aseq(1,7,1), 3) 
;
;testing the denest *******************
x = read("buffa.dat")                              
y = denest(x) 
setmaskp(y,0,0,0)
setmaskl(y,(1:rows(y))',1,1,2)
show(d1,1,3,y)
;  
x=5*(normal(200)+2)                                       
y=denest(x,3)                                         
f=sort(x~pdfn((x-2*5)/5)/5)
setmaskp(y,0,0,0)
setmaskl(y,(1:rows(y))',1,1,2)
setmaskp(f,0,0,0)
setmaskl(f,(1:rows(f))',0,1,2)
show(d1,2,3,f,y)
;  
d2=createdisplay(3,3)
;testing the denestp ******************
x = read("nicfoo.dat") 
y=denestp(x,0.6) 
setmaskp(y,0,2,4)
show(d2,1,1,y)
x = read("bank2.dat") 
y = denestp(x[,1:3],0.6,0.2)   
;
;testing the regestp *****************
n = 200                        
x  = uniform(n,2).*pi                                     
y  = sin(2*x[,1])+x[,2]+0.25*normal(n)                   
y = regestp(x~y,1) 
setmaskp(y,0,1,4)
show(d2,2,1,y)
;
;testing the lregestp *****************
n = 200                        
x  = uniform(n,2).*pi                                     
y  = sin(2*x[,1])+x[,2]+0.25*normal(n)                   
y = lregestp(x~y,1) 
setmaskp(y,0,1,4)
show(d2,3,1,y)
;
;testing the canbw *******************
canbw("qua")
;
;testing the canker *******************
canker(1, "gau", "qua")
;
;testing the dengau *******************
x = 5.*(normal(200)+2)                                       
y = denest(x,3,"gau")
setmaskp(y,0,0,0)
setmaskl(y,(1:rows(y))',0,1,2)
show(d2,1,2,y)    
;
;testing the gauder *******************
x = aseq(-1, 21, 0.1)
y = x~gauder(x,1,3)                                
setmaskp(y,0,0,0)
setmaskl(y,(1:rows(y))',0,1,2)
show(d2,2,2,y)   
;
;testing the denci ********************
x = 5*(normal(200)+2)                                       
{fh, clo, cup} = denci(x,3)                                         
f=x~pdfn((x-2*5)/5)/5                                     
setmaskp(fh,0,0,0)
setmaskl(fh,(1:rows(fh))',1,1,2)
setmaskp(clo,0,0,0)
setmaskl(clo,(1:rows(clo))',1,2,1)
setmaskp(cup,0,0,0)
setmaskl(cup,(1:rows(cup))',1,2,1)
show(d2,3,2,fh,clo,cup) 
;
;testing the dencb ********************
x = 5*(normal(200)+2)                                       
{fh, clo, cup} = denci(x,3)                                         
f=x~pdfn((x-2*5)/5)/5                                     
setmaskp(fh,0,0,0)
setmaskl(fh,(1:rows(fh))',1,1,2)
setmaskp(clo,0,0,0)
setmaskl(clo,(1:rows(clo))',1,2,1)
setmaskp(cup,0,0,0)
setmaskl(cup,(1:rows(cup))',1,2,1)
show(d2,1,3,fh,clo,cup) 
;
;testing the regci ********************
x = pi.*(uniform(200)-0.5)                               
x = x~(1-cos(x)+uniform(200))                             
{mh, clo, cup} = regci(x,0.3)                                         
setmaskp(mh,0,0,0)
setmaskl(mh,(1:rows(mh))',1,1,2)
setmaskp(clo,0,0,0)
setmaskl(clo,(1:rows(clo))',1,2,1)
setmaskp(cup,0,0,0)
setmaskl(cup,(1:rows(cup))',1,2,1)
show(d2,2,3,mh,clo,cup)  
;
;testing the regcb ********************
x = pi.*(uniform(200)-0.5)                               
x = x~(1-cos(x)+uniform(200))                             
{mh,clo, cup} = regcb(x,0.3)                                         
setmaskp(mh,0,0,0)
setmaskl(mh,(1:rows(mh))',1,1,2)
setmaskp(clo,0,0,0)
setmaskl(clo,(1:rows(clo))',1,2,1)
setmaskp(cup,0,0,0)
setmaskl(cup,(1:rows(cup))',1,2,1)
show(d2,3,3,mh,clo,cup)  
;
;testing the bwsel ********************  
;x = normal(100)
;bwsel(x)
         
endp










