proc (gamma1, gamma2) = sssm (vectY,matX,nameX,auto,vObs,vSel,nbslices)
; ----------------------------------------------------------------------
;   Library 	  metrics
; ----------------------------------------------------------------------
;   See_also	  heckman select powell andrews
; ----------------------------------------------------------------------
;   Macro	  sssm
; ----------------------------------------------------------------------
;   Description   computes the estimates of the slope vectors in the outcome
;		  equation and in the selection equation for a 
;		  semiparametric sample selection model (SSSM).
;		  This is a two-stages estimation method:
;		  the first one is a taylored Sliced Inverse Regression (S.I.R.)
;		  analysis,
;		  and, in the second one, two Canonical analyses are conducted
;		  in order to convert the estimated EDR directions into 
;		  estimates of the slopes.
;		  The identifiability conditions have to be verified:
;		  there exists a component of the explanatory variable X
;		  which affects the selection and does not affect the
;		  outcome, and there also exists another component of X
;		  which affects the outcome and does not affect the selection.
;		  If these identifiability conditions are not verified, 
;		  the program stops.
;		  Moreover, the number of explanatory variables for the
;		  selection (resp. outcome) equation must be greater 
;		  or equal than 2.
; ----------------------------------------------------------------------
;   Usage         (gamma1, gamma2) = sssm (vectY,matX,nameX{,auto,vObs,vSel,nbslices})
; ----------------------------------------------------------------------
;   Input 
;     Parameter   vectY 
;     Definition  n x 1 matrix containing the observed response variable.
;	          (The missing values are assumed to be equal to zero.)
;     Parameter   matX
;     Definition  n x p matrix containing the observed explanatory 
;		  variables.	
;     Parameter   nameX
;     Definition  p x 1 matrix containing the names of the explanatory 
;		  variables.
;     Parameter   auto
;     Definition  optional parameter, (by default, auto=1).
;		  If (auto=0), then you have to specify the vectors "vObs" 
;		  and "vSel", else (auto=1) you have to specify your selection of
;		  the explanatory variables used in the outcome equation
;		  and in the selection equation during the execution of 
;		  this macro in two selectitem windows.
;     Parameter   vObs
;     Definition  optional parameter if auto=0,
;		  otherwise, p x 1 matrix containing the indicator vector of the explanatory 
;		  variables used in the outcome equation.
;		  (1 if the explanatory variable is selected, 0 otherwise.)
;     Parameter   vSel
;     Definition  optional parameter if auto=0,
;		  otherwise, p x 1 matrix containing the indicator vector of the explanatory 
;		  variables used in the selection equation.
;		  (1 if the explanatory variable is selected, 0 otherwise.)
;     Parameter   nbslices
;     Definition  optional parameter, scalar which gives the number of
;	          slices (for the non missing yi observations) in the S.I.R. step.
;		  (By default, the number of slices is 5 (+ 1 slice for the
;		  missing yi cases).)
;
;   Output
;     Parameter   gamma1
;     Definition  estimate of the observation slope vector.
;     Parameter   gamma2
;     Definition  estimate of the selection slope vector.
; ----------------------------------------------------------------------
;   Example       library("metrics")
;		  n=500
;		  sigmaU=#(1,0.5)~#(0.5,1)
;		  sigmaX=diag(#(1,1,1,1,1))
;		  gamma1=#(1,1,1,1)
;		  gamma2=#(1,1,-1,-1)
;		  v1=#(1,1,1,1,0)
;		  v2=#(0,1,1,1,1)
;	       	  U=gennorm(n,#(0,0),sigmaU)
;	   	  X=gennorm(n,#(0,0,0,0,0),sigmaX)
;		  xselec=(X[,2:5]*gamma2)+U[,2]
;		  indexSelec=( xselec.>=0)
;		  Yall=exp(X[,1:4]*gamma1+U[,1])
;		  Y=Yall.*indexSelec
;		  nameX="x1"|"x2"|"x3"|"x4"|"x5"
;		  rsssm=sssm(Y,X,nameX,0,v1,v2)
;		  rsssm.gamma1
;		  rsssm.gamma2
;		  rsssm=sssm(Y,X,nameX)
;		  rsssm.gamma1
;		  rsssm.gamma2
; ----------------------------------------------------------------------
;   Result
;		  the estimates of the outcome and selection slope vectors.
; ----------------------------------------------------------------------
;   Reference   Saracco Jerome (1996): Distribution-free and link-free fast
;               estimation for Sample Selection Models. Preprint.
; ----------------------------------------------------------------------
;   Author        Saracco Jerome, 961121
; ----------------------------------------------------------------------
matYX=vectY~matX
p=cols(matX)
F=0
T=1
if (exist(auto)==0)
auto=1
endif
if (auto==0)
vectA1=vObs
vectA2=vSel
else
if ( exist(vObs)==0 )
vObs=0
endif
if ( exist(vSel)==0 )
vSel=0
endif
;
; Interactive selection of the explanatory variables 
; for the selection ant outcome equations.
;
vectA1 = selectitem("Selection of the regressors for the outcome",nameX)
vectA2 = selectitem("Selection of the regressors for the selection",nameX)
;
endif
;
; Check of the number of variables for the selection equation and for the
; outcome equation.
;
error((sum(vectA2)<=1),"The number of explanatory variables in 
the selection equation must be >=2.")
error((sum(vectA1)<=1),"The number of explanatory variables in 
the outcome equation must be >=2.")
;
; Check of the identifiabilty conditions.
;
j=1
check1=F
check2=F
while(j<=p)
if (check1==F)
if ((vectA1[j]==1) && (vectA2[j]==0))
check1=T
endif
endif
if (check2==F)
if ((vectA1[j]==0) && (vectA2[j]==1))
check2=T
endif
endif
j=j+1
endo
if ((check1==F) || (check2==F))
check=F
error(check==F,"The identifiability conditions are not verified.")
endif
;
; Building the selection matrices A1 and A2.
;
p1=sum(vectA1)
p2=sum(vectA2)
matA1=matrix(p,p1)*0
matA2=matrix(p,p2)*0
j=1
col1=0
col2=0
while (j<=p)
if (vectA1[j]==1)
col1=col1+1
matA1[j,col1]=1
endif
if (vectA2[j]==1)
col2=col2+1
matA2[j,col2]=1
endif
j=j+1
endo
;
; Step 1: Sliced Inverse Regression.
;
if (exist(nbslices)==0)
nbslices=5
endif
resSIR= sir1(matYX,nbslices)
matEDR=resSIR.edr
matB=matEDR[,1:2]
;
; Step 2: Canonical Analyses (with symmetric matrices).
;
P=matB*inv(matB'*matB)*matB'
P1=matA1*inv(matA1'*matA1)*matA1'
P2=matA2*inv(matA2'*matA2)*matA2'
ed1=eigsm(P1*P*P1)
o=order(-ed1.values)
ed1.vectors=ed1.vectors[,o]
ed1.values=ed1.values[o]
gamtild1=ed1.vectors[,1]
ed2=eigsm(P2*P*P2)
o=order(-ed2.values)
ed2.vectors=ed2.vectors[,o]
ed2.values=ed2.values[o]
gamtild2=ed2.vectors[,1]
;
; Step 3: Estimation of the slopes vectors.
;
gamma1=matA1'*gamtild1
gamma2=matA2'*gamtild2
endp
